/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.model;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.model.MMTimer;
import edu.colorado.phet.movingman.model.Mode;
import edu.colorado.phet.movingman.model.MovingManTimeModel;

public class PlaybackMode
extends Mode {
    private double playbackSpeed;
    private MovingManModule module;
    private MMTimer timer = new MMTimer(SimStrings.get("controls.playback"));

    public PlaybackMode(MovingManModule movingManModule, MovingManTimeModel movingManTimeModel) {
        super(movingManModule, SimStrings.get("controls.playback"), false);
        this.module = movingManModule;
    }

    public void setPlaybackSpeed(double d) {
        this.playbackSpeed = d;
    }

    public void initialize() {
        this.module.initialize();
        this.module.getMovingManApparatusPanel().setCursorsVisible(true);
    }

    public void stepInTime(double d) {
        if (!this.module.isPaused()) {
            this.module.getPlaybackTimer().stepInTime(d * this.playbackSpeed, this.module.getRecordingTimer().getTime());
            double d2 = this.module.getPlaybackTimer().getTime();
            double d3 = this.module.getRecordingTimer().getTime();
            if (d2 < d3) {
                this.module.setReplayTime(d2);
            } else {
                this.module.setPaused(true);
                this.module.firePlaybackFinished();
            }
        }
    }

    public void reset() {
        this.timer.reset();
    }

    public void rewind() {
        this.timer.setTime(0.0);
    }

    public MMTimer getTimer() {
        return this.timer;
    }
}

