/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.model;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.model.MMTimer;
import edu.colorado.phet.movingman.model.Mode;
import edu.colorado.phet.movingman.model.MovingManTimeModel;
import edu.colorado.phet.movingman.model.TimeListenerAdapter;

public class RecordMode
extends Mode {
    private MovingManModule module;
    private MMTimer timer = new MMTimer(SimStrings.get("controls.record"));

    public RecordMode(final MovingManModule movingManModule, MovingManTimeModel movingManTimeModel) {
        super(movingManModule, SimStrings.get("RecordMode.ModeName"), true);
        this.module = movingManModule;
        movingManTimeModel.addListener(new TimeListenerAdapter(){

            public void recordingStarted() {
                movingManModule.setSmoothingSharp();
            }
        });
    }

    public void initialize() {
        this.module.initialize();
        int n = this.module.getPosition().numSmoothedPoints() - 1;
        this.module.setReplayTime(n);
        this.module.repaintBackground();
    }

    public void stepInTime(double d) {
        double d2 = this.module.getRecordingTimer().getTime();
        double d3 = this.module.getMaxTime();
        if (!this.module.isPaused()) {
            if (d2 >= d3) {
                this.module.recordingFinished();
                return;
            }
            double d4 = d2 + d;
            if (d4 > d3) {
                d = d3 - d2;
            }
            this.module.getRecordingTimer().stepInTime(d, d3);
            this.module.getMan().stepInTime(d);
            this.module.step(d);
            if (d4 >= d3) {
                this.module.recordingFinished();
                return;
            }
        }
    }

    public void reset() {
        this.timer.reset();
    }

    public MMTimer getTimer() {
        return this.timer;
    }
}

