/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.motion;

import edu.colorado.phet.common.motion.graphs.ControlGraphSeries;
import edu.colorado.phet.common.motion.graphs.GraphSetModel;
import edu.colorado.phet.common.motion.graphs.GraphSetNode;
import edu.colorado.phet.common.motion.graphs.GraphSuite;
import edu.colorado.phet.common.motion.graphs.MinimizableControlGraph;
import edu.colorado.phet.common.motion.model.SingleBodyMotionModel;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common.piccolophet.BufferedPhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.PDebugKeyHandler;
import edu.colorado.phet.common.timeseries.ui.TimeSeriesControlPanel;
import edu.colorado.phet.movingman.motion.MovingManGraph;
import edu.colorado.phet.movingman.motion.MovingManNode;
import edu.umd.cs.piccolo.event.PZoomEventHandler;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MovingManMotionApplication {
    private JFrame frame = new JFrame("Moving Man Motion Application");
    private ConstantDtClock clock;

    public MovingManMotionApplication() {
        this.frame.setSize(Toolkit.getDefaultToolkit().getScreenSize().width, Toolkit.getDefaultToolkit().getScreenSize().height - 400);
        BufferedPhetPCanvas bufferedPhetPCanvas = new BufferedPhetPCanvas();
        bufferedPhetPCanvas.setZoomEventHandler(new PZoomEventHandler());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)bufferedPhetPCanvas, "Center");
        this.frame.setContentPane(jPanel);
        this.frame.setDefaultCloseOperation(3);
        this.clock = new ConstantDtClock(30, 1.0);
        SingleBodyMotionModel singleBodyMotionModel = new SingleBodyMotionModel(this.clock);
        System.out.println("motionModel.getTimeSeriesModel().getMode() = " + singleBodyMotionModel.getTimeSeriesModel().getMode() + " ispaused=" + singleBodyMotionModel.getTimeSeriesModel().isPaused());
        MovingManNode movingManNode = new MovingManNode(singleBodyMotionModel);
        movingManNode.scale(50.0);
        movingManNode.translate(10.5, 0.0);
        bufferedPhetPCanvas.addScreenChild(movingManNode);
        singleBodyMotionModel.setPositionDriven();
        int n = 500;
        singleBodyMotionModel.setMaxAllowedRecordTime(n);
        System.out.println("motionModel.getTimeSeriesModel().getMode() = " + singleBodyMotionModel.getTimeSeriesModel().getMode() + " ispaused=" + singleBodyMotionModel.getTimeSeriesModel().isPaused());
        ControlGraphSeries controlGraphSeries = new ControlGraphSeries("X", Color.blue, "x", "m", new BasicStroke(2.0f), true, null, singleBodyMotionModel.getXVariable());
        MovingManGraph movingManGraph = new MovingManGraph(bufferedPhetPCanvas, controlGraphSeries, SimStrings.get("variables.position.abbreviation"), "x", -10.0, 10.0, singleBodyMotionModel, true, singleBodyMotionModel.getTimeSeriesModel(), singleBodyMotionModel.getPositionDriven(), n, singleBodyMotionModel);
        ControlGraphSeries controlGraphSeries2 = new ControlGraphSeries("V", Color.red, "v", "m/s", new BasicStroke(2.0f), true, null, singleBodyMotionModel.getVVariable());
        MovingManGraph movingManGraph2 = new MovingManGraph(bufferedPhetPCanvas, controlGraphSeries2, SimStrings.get("variables.velocity.abbreviation"), "x", -1.0, 1.0, singleBodyMotionModel, true, singleBodyMotionModel.getTimeSeriesModel(), singleBodyMotionModel.getVelocityDriven(), n, singleBodyMotionModel);
        ControlGraphSeries controlGraphSeries3 = new ControlGraphSeries("A", Color.green, "a", "m/s^2", new BasicStroke(2.0f), true, null, singleBodyMotionModel.getAVariable());
        MovingManGraph movingManGraph3 = new MovingManGraph(bufferedPhetPCanvas, controlGraphSeries3, SimStrings.get("variables.position.abbreviation"), "x", -0.01, 0.01, singleBodyMotionModel, true, singleBodyMotionModel.getTimeSeriesModel(), singleBodyMotionModel.getAccelDriven(), n, singleBodyMotionModel);
        GraphSetNode graphSetNode = new GraphSetNode(new GraphSetModel(new GraphSuite(new MinimizableControlGraph[]{new MinimizableControlGraph(SimStrings.get("variables.position.abbreviation"), movingManGraph), new MinimizableControlGraph(SimStrings.get("variables.velocity.abbreviation"), movingManGraph2), new MinimizableControlGraph(SimStrings.get("variables.acceleration.abbreviation"), movingManGraph3)})));
        graphSetNode.setAlignedLayout();
        graphSetNode.setBounds(0.0, 0.0, 800.0, 600.0);
        graphSetNode.setOffset(0.0, 200.0);
        bufferedPhetPCanvas.addScreenChild(graphSetNode);
        bufferedPhetPCanvas.requestFocus();
        bufferedPhetPCanvas.addKeyListener(new PDebugKeyHandler());
        TimeSeriesControlPanel timeSeriesControlPanel = new TimeSeriesControlPanel(singleBodyMotionModel.getTimeSeriesModel(), 0.1, 1.0);
        jPanel.add((Component)timeSeriesControlPanel, "South");
    }

    private void start() {
        this.frame.setVisible(true);
        this.clock.start();
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SimStrings.getInstance().addStrings("moving-man/localization/moving-man-strings");
                new MovingManMotionApplication().start();
            }
        });
    }
}

