/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.plotdevice;

import edu.colorado.phet.chart_movingman.BufferedChart;
import edu.colorado.phet.chart_movingman.Chart;
import edu.colorado.phet.chart_movingman.Range2D;
import edu.colorado.phet.chart_movingman.controllers.BufferedChartCursor;
import edu.colorado.phet.chart_movingman.controllers.ChartCursor;
import edu.colorado.phet.chart_movingman.controllers.ChartSlider;
import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_movingman.view.ApparatusPanel;
import edu.colorado.phet.common_movingman.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common_movingman.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_movingman.view.util.BufferedImageUtils;
import edu.colorado.phet.common_movingman.view.util.ImageLoader;
import edu.colorado.phet.movingman.common.ZoomControl;
import edu.colorado.phet.movingman.plotdevice.PlotDeviceListener;
import edu.colorado.phet.movingman.plotdevice.PlotDeviceSeries;
import edu.colorado.phet.movingman.plotdevice.RepeatClicker;
import edu.colorado.phet.movingman.plots.TimePoint;
import edu.colorado.phet.movingman.plots.TimeSeries;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class PlotDevice
extends GraphicLayerSet {
    private Color chartBackgroundColor = new Color(250, 247, 224);
    private String name;
    private ArrayList listeners = new ArrayList();
    private ArrayList data = new ArrayList();
    private PhetGraphic minimizeButton;
    private PhetGraphic zoomPanel;
    private ChartSlider chartSlider;
    private BufferedChartCursor cursor;
    private Chart chart;
    private BufferedChart bufferedChart;
    private ZoomControl horizontalZoomControl;
    private ZoomControl verticalZoomControl;
    private static double MIN_TIME = 2.0;
    private static double MAX_TIME = 20.0;
    private static double MAX_Y = 100.0;
    private static double MIN_Y = 2.0;

    public PlotDevice(ApparatusPanel apparatusPanel, Range2D range2D, String string, String string2, Color color) {
        super(apparatusPanel);
        this.name = string;
        Dimension dimension = new Dimension(600, 200);
        this.chart = new Chart(apparatusPanel, range2D, dimension);
        this.chart.setBackground(this.chartBackgroundColor);
        this.chart.getVerticalGridlines().setMajorGridlinesColor(Color.gray);
        this.chart.getVerticalGridlines().setMinorGridlinesColor(Color.gray);
        this.chart.getHorizonalGridlines().setMajorGridlinesColor(Color.gray);
        this.chart.getHorizonalGridlines().setMinorGridlinesColor(Color.gray);
        this.chart.getXAxis().setStroke(new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{8.0f, 4.0f}, 0.0f));
        this.chart.getHorizontalTicks().setVisible(false);
        try {
            this.zoomPanel = new ZoomPanel(this);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.chartSlider = new ChartSlider(apparatusPanel, this.chart, string2, color);
        this.minimizeButton = this.createMinimizeButton();
        this.addGraphic(this.chartSlider);
        this.chartSlider.addListener(new ChartSlider.Listener(){

            public void valueChanged(double d) {
                for (int i = 0; i < PlotDevice.this.listeners.size(); ++i) {
                    PlotDeviceListener plotDeviceListener = (PlotDeviceListener)PlotDevice.this.listeners.get(i);
                    plotDeviceListener.sliderDragged(d);
                }
            }
        });
        this.addGraphic(this.minimizeButton);
        this.bufferedChart = new BufferedChart((Component)apparatusPanel, this.chart);
        this.cursor = new BufferedChartCursor(apparatusPanel, this.chart, 7, this.bufferedChart);
        this.cursor.addListener(new ChartCursor.Listener(){

            public void modelValueChanged(double d) {
                PlotDevice.this.fireCursorDragged(d);
            }
        });
        this.addGraphic(this.cursor);
        final ValueChange valueChange = new ValueChange(5.0, 0.0, MAX_Y);
        final ValueChange valueChange2 = new ValueChange(-5.0, 0.0, MAX_Y);
        this.horizontalZoomControl = new ZoomControl(apparatusPanel, 0);
        this.horizontalZoomControl.addZoomListener(new ZoomControl.ZoomListener(){

            public void zoomPerformed(ZoomControl.ZoomEvent zoomEvent) {
                if (zoomEvent.getZoomType() == 2) {
                    PlotDevice.this.horizontalZoom(-1.0);
                } else {
                    PlotDevice.this.horizontalZoom(1.0);
                }
            }
        });
        this.addGraphic(this.horizontalZoomControl);
        this.verticalZoomControl = new ZoomControl(apparatusPanel, 1);
        this.verticalZoomControl.addZoomListener(new ZoomControl.ZoomListener(){

            public void zoomPerformed(ZoomControl.ZoomEvent zoomEvent) {
                if (zoomEvent.getZoomType() == 0) {
                    valueChange.actionPerformed(null);
                } else {
                    valueChange2.actionPerformed(null);
                }
            }
        });
        this.addGraphic(this.verticalZoomControl);
        this.setChartSize(600, 200);
        this.updateZoomButtonsEnabled();
    }

    private void fireCursorDragged(double d) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            PlotDeviceListener plotDeviceListener = (PlotDeviceListener)this.listeners.get(i);
            plotDeviceListener.cursorDragged(d);
        }
    }

    public void reset() {
        this.chartSlider.setValue(0.0);
        for (int i = 0; i < this.data.size(); ++i) {
            PlotDeviceSeries plotDeviceSeries = (PlotDeviceSeries)this.data.get(i);
            plotDeviceSeries.reset();
        }
        this.rebuildChartBuffer();
    }

    public void setChartSize(int n, int n2) {
        int n3 = 8;
        int n4 = this.horizontalZoomControl.getWidth() + n3 * 2;
        this.chart.setChartSize(n - n4, n2);
        this.rebuildChartBuffer();
        int n5 = (int)((double)this.chartSlider.getWidth() / 2.0);
        this.chartSlider.setBounds(-this.chartSlider.getWidth() * 2 - 2, -n5 / 2, this.chartSlider.getWidth(), n2 + n5);
        this.zoomPanel.setLocation(this.chart.getChartBounds().width + 5, 0);
        this.horizontalZoomControl.setLocation(this.chart.getChartBounds().width + n3, this.chart.getChartBounds().height - this.horizontalZoomControl.getHeight() - 2);
        this.verticalZoomControl.setLocation(this.chart.getChartBounds().width + n3, this.chart.getChartBounds().height - this.horizontalZoomControl.getHeight() * 2 - 2 - 5);
        this.minimizeButton.setLocation(this.chart.getChartBounds().width - this.minimizeButton.getWidth() - 2, 2);
        this.setBoundsDirty();
        this.autorepaint();
    }

    private void rebuildChartBuffer() {
        if (this.bufferedChart != null) {
            this.removeGraphic(this.bufferedChart);
        }
        this.bufferedChart = new BufferedChart(this.getComponent(), this.chart);
        this.bufferedChart.setLocation(this.chart.getLocalBounds().x, this.chart.getLocalBounds().y);
        this.cursor.setBufferedChart(this.bufferedChart);
        this.addGraphic(this.bufferedChart, -1.0);
        for (int i = 0; i < this.data.size(); ++i) {
            PlotDeviceSeries plotDeviceSeries = (PlotDeviceSeries)this.data.get(i);
            plotDeviceSeries.chartChanged();
        }
        this.setBoundsDirty();
    }

    private void setMagnitude(double d) {
        Range2D range2D = this.chart.getRange();
        Range2D range2D2 = new Range2D(range2D);
        range2D2.setMaxY(d);
        range2D2.setMinY(-d);
        this.chart.setRange(range2D2);
    }

    public void requestTypingFocus() {
    }

    public void addListener(PlotDeviceListener plotDeviceListener) {
        this.listeners.add(plotDeviceListener);
    }

    public double getSliderValue() {
        return this.chartSlider.getValue();
    }

    public Chart getChart() {
        return this.chart;
    }

    private BufferedImage testResize(BufferedImage bufferedImage, double d) {
        if (this.isLowResolution()) {
            bufferedImage = BufferedImageUtils.rescaleYMaintainAspectRatio(this.getComponent(), bufferedImage, (int)((double)bufferedImage.getHeight() * d));
        }
        return bufferedImage;
    }

    private boolean isLowResolution() {
        return Toolkit.getDefaultToolkit().getScreenSize().width <= 1024;
    }

    private PhetGraphic createMinimizeButton() {
        try {
            BufferedImage bufferedImage = ImageLoader.loadBufferedImage("moving-man/images/min1.jpg");
            bufferedImage = this.testResize(bufferedImage, 0.75);
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            JButton jButton = new JButton(imageIcon);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < PlotDevice.this.listeners.size(); ++i) {
                        PlotDeviceListener plotDeviceListener = (PlotDeviceListener)PlotDevice.this.listeners.get(i);
                        plotDeviceListener.minimizePressed();
                    }
                }
            });
            return PhetJComponent.newInstance(this.getComponent(), jButton);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public void addPlotDeviceData(PlotDeviceSeries plotDeviceSeries) {
        this.data.add(plotDeviceSeries);
        this.addGraphic(plotDeviceSeries);
        plotDeviceSeries.setLocation(10, 5);
        plotDeviceSeries.getRawData().addObserver(new TimeSeries.Observer(){

            public void dataAdded(TimeSeries timeSeries) {
                PlotDevice.this.chartSlider.setValue(timeSeries.getLastPoint().getValue());
            }

            public void cleared(TimeSeries timeSeries) {
            }
        });
    }

    public BufferedChart getBufferedChart() {
        return this.bufferedChart;
    }

    public void setPlaybackTime(double d) {
        Object object;
        int n;
        this.cursor.setX(d);
        for (n = 0; n < this.data.size(); ++n) {
            object = (PlotDeviceSeries)this.data.get(n);
            ((PlotDeviceSeries)object).setPlaybackTime(d);
        }
        if (this.data.size() > 0) {
            PlotDeviceSeries plotDeviceSeries = (PlotDeviceSeries)this.data.get(0);
            object = plotDeviceSeries.getRawData().getValueForTime(d);
            this.chartSlider.setValue(((TimePoint)object).getValue());
        }
        for (n = 0; n < this.listeners.size(); ++n) {
            object = (PlotDeviceListener)this.listeners.get(n);
            object.playbackTimeChanged();
        }
    }

    private boolean isHighResolution() {
        return !this.isLowResolution();
    }

    public void setPaintYLines(double[] dArray) {
        double[] dArray2 = new double[dArray.length * 2 + 1];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i];
            dArray2[dArray2.length - 1 - i] = -dArray[i];
        }
        dArray2[dArray.length] = 0.0;
        double[] dArray3 = new double[dArray.length * 2];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i];
            dArray3[dArray3.length - 1 - i] = -dArray[i];
        }
        this.chart.getHorizonalGridlines().setMajorGridlines(dArray3);
        this.chart.getVerticalTicks().setMajorGridlines(dArray2);
        this.chart.getYAxis().setMajorGridlines(dArray2);
    }

    public void setCursorVisible(boolean bl) {
        this.cursor.setVisible(bl);
        this.notifyCursorListeners(bl);
    }

    private void notifyCursorListeners(boolean bl) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            PlotDeviceListener plotDeviceListener = (PlotDeviceListener)this.listeners.get(i);
            plotDeviceListener.cursorVisibilityChanged(bl);
        }
    }

    public void setChartRange(Range2D range2D) {
        this.chart.setRange(range2D);
        this.rebuildChartBuffer();
    }

    public String getName() {
        return this.name;
    }

    public PlotDeviceSeries dataSeriesAt(int n) {
        return (PlotDeviceSeries)this.data.get(n);
    }

    public ChartSlider getChartSlider() {
        return this.chartSlider;
    }

    private void horizontalZoom(double d) {
        this.setMaxTime(this.getMaxTime() + d);
    }

    public void updateZoomButtonsEnabled() {
        this.horizontalZoomControl.setZoomInEnabled(this.getMaxTime() > MIN_TIME);
        this.horizontalZoomControl.setZoomOutEnabled(this.getMaxTime() < MAX_TIME);
        this.verticalZoomControl.setZoomOutEnabled(this.chart.getRange().getMaxY() < 95.0);
        this.verticalZoomControl.setZoomInEnabled(this.chart.getRange().getMaxY() > MIN_Y);
    }

    public void setMaxTime(double d) {
        if (d != this.getMaxTime() && d <= MAX_TIME && d >= MIN_TIME) {
            this.chart.setRange(new Range2D(this.chart.getRange().getMinX(), this.chart.getRange().getMinY(), d, this.chart.getRange().getMaxY()));
            this.rebuildChartBuffer();
            this.notifyBufferChanged();
            this.notifyMaxTimeChanged();
            this.updateZoomButtonsEnabled();
        }
    }

    private void notifyMaxTimeChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            PlotDeviceListener plotDeviceListener = (PlotDeviceListener)this.listeners.get(i);
            plotDeviceListener.maxTimeChanged(this.getMaxTime());
        }
    }

    private double getMaxTime() {
        return this.chart.getRange().getMaxX();
    }

    private void notifyBufferChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            PlotDeviceListener plotDeviceListener = (PlotDeviceListener)this.listeners.get(i);
            plotDeviceListener.bufferChanged();
        }
    }

    private double[] getYLines(double d, double d2) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (double d3 = d2; d3 < d; d3 += d2) {
            arrayList.add(new Double(d3));
        }
        if (arrayList.size() > 5) {
            return this.getYLines(d, d2 * 2.0);
        }
        if (arrayList.size() <= 1) {
            return this.getYLines(d, d2 / 2.0);
        }
        double[] dArray = new double[arrayList.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (Double)arrayList.get(i);
        }
        return dArray;
    }

    public int getNumDataSeries() {
        return this.data.size();
    }

    public BufferedChartCursor getCursor() {
        return this.cursor;
    }

    public int numPlotDeviceData() {
        return this.data.size();
    }

    public PlotDeviceSeries plotDeviceSeriesAt(int n) {
        return (PlotDeviceSeries)this.data.get(n);
    }

    class ValueChange
    implements ActionListener {
        double increment;
        private double min;
        private double max;

        public ValueChange(double d, double d2, double d3) {
            this.increment = d;
            this.min = d2;
            this.max = d3;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Range2D range2D = PlotDevice.this.chart.getRange();
            double d = range2D.getMaxY();
            double d2 = d - this.increment;
            if (d2 > this.min && d2 < this.max) {
                PlotDevice.this.setMagnitude(d2);
                PlotDevice.this.setPaintYLines(PlotDevice.this.getYLines(d2, 5.0));
                PlotDevice.this.rebuildChartBuffer();
                PlotDevice.this.notifyBufferChanged();
                PlotDevice.this.updateZoomButtonsEnabled();
            }
        }
    }

    class MagButton
    extends JButton {
        public MagButton(Icon icon, ActionListener actionListener, ActionListener actionListener2, String string) {
            super(icon);
            this.addMouseListener(new RepeatClicker(actionListener, actionListener2));
            this.setToolTipText(string);
            this.setForeground(Color.white);
            this.setBackground(Color.white);
        }
    }

    public class ZoomPanel
    extends GraphicLayerSet {
        public ZoomPanel(PlotDevice plotDevice2) throws IOException {
            BufferedImage bufferedImage = ImageLoader.loadBufferedImage("moving-man/images/icons/plus-tiny.gif");
            BufferedImage bufferedImage2 = ImageLoader.loadBufferedImage("moving-man/images/icons/minus-tiny.gif");
            if (PlotDevice.this.isHighResolution()) {
                bufferedImage = ImageLoader.loadBufferedImage("moving-man/images/icons/glass-20-plus.gif");
                bufferedImage2 = ImageLoader.loadBufferedImage("moving-man/images/icons/glass-20-minus.gif");
            }
            ValueChange valueChange = new ValueChange(1.0, 0.0, 100.0);
            ValueChange valueChange2 = new ValueChange(-1.0, 0.0, 100.0);
            ValueChange valueChange3 = new ValueChange(5.0, 0.0, 100.0);
            ValueChange valueChange4 = new ValueChange(-5.0, 0.0, 100.0);
            MagButton magButton = new MagButton(new ImageIcon(bufferedImage), valueChange, valueChange3, SimStrings.get("plot.zoom-in"));
            MagButton magButton2 = new MagButton(new ImageIcon(bufferedImage2), valueChange2, valueChange4, SimStrings.get("plot.zoom-out"));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(magButton2);
            jPanel.add(magButton);
            PhetGraphic phetGraphic = PhetJComponent.newInstance(plotDevice2.getComponent(), jPanel);
            this.addGraphic(phetGraphic);
        }
    }
}

