/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.plotdevice;

import edu.colorado.phet.chart_movingman.BufferedLinePlot;
import edu.colorado.phet.chart_movingman.DataSet;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common_movingman.view.graphics.transforms.LinearTransform2D;
import edu.colorado.phet.common_movingman.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetShadowTextGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.ShadowHTMLGraphic;
import edu.colorado.phet.movingman.plotdevice.PlotDevice;
import edu.colorado.phet.movingman.plots.TimePoint;
import edu.colorado.phet.movingman.plots.TimeSeries;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.Random;

public class PlotDeviceSeries
extends CompositePhetGraphic {
    private PlotDevice plotDevice;
    private TimeSeries rawData;
    private Color color;
    private String name;
    private Stroke stroke;
    private DataSet storedData;
    private BufferedLinePlot bufferedLinePlot;
    static final Random debuggingRandom = new Random(0L);
    private PhetShadowTextGraphic readoutGraphic;
    private DefaultDecimalFormat decimalFormat = new DefaultDecimalFormat("0.0");
    private ShadowHTMLGraphic unitsGraphic;
    private PhetShadowTextGraphic nameGraphic;
    private ShadowHTMLGraphic justifyMetric;

    public PlotDeviceSeries(PlotDevice plotDevice, TimeSeries timeSeries, Color color, String string, Stroke stroke, Font font, String string2, String string3) {
        super(plotDevice.getComponent());
        this.plotDevice = plotDevice;
        this.rawData = timeSeries;
        this.color = color;
        this.name = string;
        this.stroke = stroke;
        this.storedData = new DataSet();
        this.bufferedLinePlot = new BufferedLinePlot(plotDevice.getBufferedChart(), this.stroke, color);
        this.bufferedLinePlot.setAutoRepaint(true);
        timeSeries.addObserver(new TimeSeriesObserver());
        this.readoutGraphic = new PhetShadowTextGraphic(plotDevice.getComponent(), font, "text", color, 1, 1, Color.black);
        this.unitsGraphic = new ShadowHTMLGraphic(this.getComponent(), string2, font, color, 1, 1, Color.black);
        this.nameGraphic = new PhetShadowTextGraphic(plotDevice.getComponent(), font, string + ": ", color, 1, 1, Color.black);
        this.justifyMetric = new ShadowHTMLGraphic(this.getComponent(), string3, font, Color.blue, 1, 1, Color.gray);
        this.addGraphic(this.nameGraphic);
        this.readoutGraphic.setLocation(this.nameGraphic.getX() + this.nameGraphic.getWidth(), this.nameGraphic.getY());
        this.addGraphic(this.readoutGraphic);
        this.addGraphic(this.unitsGraphic);
        this.clearValue();
    }

    private void clearValue() {
        this.bufferedLinePlot.clear();
        TimePoint timePoint = new TimePoint(0.0, 0.0);
        this.updateReadoutGraphic(timePoint);
    }

    public void setPlaybackTime(double d) {
        TimePoint timePoint = this.rawData.getValueForTime(d);
        this.updateReadoutGraphic(timePoint);
    }

    public void setReadoutValue(double d) {
        this.updateReadoutGraphic(d);
    }

    private void updateReadoutGraphic(double d) {
        this.readoutGraphic.setAutorepaint(false);
        String string = this.decimalFormat.format(d);
        String string2 = string + " ";
        this.readoutGraphic.setText(string2);
        int n = this.justifyMetric.getWidth() - this.readoutGraphic.getWidth();
        this.readoutGraphic.setLocation(this.nameGraphic.getX() + this.nameGraphic.getWidth() + n, this.nameGraphic.getY());
        this.unitsGraphic.setLocation(this.readoutGraphic.getX() + this.readoutGraphic.getWidth(), this.nameGraphic.getLocalBounds().y);
        this.readoutGraphic.setAutorepaint(true);
        this.readoutGraphic.autorepaint();
    }

    private void updateReadoutGraphic(TimePoint timePoint) {
        this.updateReadoutGraphic(timePoint.getValue());
    }

    public void chartChanged() {
        this.bufferedLinePlot.setBufferedChart(this.plotDevice.getBufferedChart());
        this.bufferedLinePlot.clear();
        for (int i = 0; i < this.storedData.size(); ++i) {
            this.bufferedLinePlot.lineTo(this.storedData.pointAt(i));
        }
    }

    public TimeSeries getRawData() {
        return this.rawData;
    }

    public Color getColor() {
        return this.color;
    }

    public void reset() {
        this.rawData.reset();
        this.storedData.clear();
    }

    private class TimeSeriesObserver
    implements TimeSeries.Observer {
        private TimeSeriesObserver() {
        }

        public void dataAdded(TimeSeries timeSeries) {
            TimePoint timePoint = timeSeries.getLastPoint();
            PlotDeviceSeries.this.storedData.addPoint(timePoint.getTime(), timePoint.getValue());
            Rectangle rectangle = PlotDeviceSeries.this.bufferedLinePlot.lineTo(PlotDeviceSeries.this.storedData.getLastPoint());
            Rectangle rectangle2 = new Rectangle(PlotDeviceSeries.this.plotDevice.getBufferedChart().getSize());
            Rectangle rectangle3 = new Rectangle(PlotDeviceSeries.this.plotDevice.getBufferedChart().getBounds());
            LinearTransform2D linearTransform2D = new LinearTransform2D(rectangle2, rectangle3, false);
            Rectangle rectangle4 = linearTransform2D.createTransformedShape(rectangle).getBounds();
            if (rectangle != null) {
                PlotDeviceSeries.this.plotDevice.getComponent().repaint(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
            }
            PlotDeviceSeries.this.updateReadoutGraphic(timePoint);
        }

        public void cleared(TimeSeries timeSeries) {
            PlotDeviceSeries.this.clearValue();
        }
    }
}

