/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.plots;

import edu.colorado.phet.chart_movingman.Range2D;
import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.model.MMTimer;
import edu.colorado.phet.movingman.model.Man;
import edu.colorado.phet.movingman.model.TimeListenerAdapter;
import edu.colorado.phet.movingman.plotdevice.PlotDevice;
import edu.colorado.phet.movingman.plotdevice.PlotDeviceListenerAdapter;
import edu.colorado.phet.movingman.plotdevice.PlotDeviceSeries;
import edu.colorado.phet.movingman.view.MovingManApparatusPanel;
import java.awt.Color;

public class MMPlot
extends PlotDevice {
    private MovingManModule module;
    private String varname;

    public MMPlot(final MovingManModule movingManModule, final MovingManApparatusPanel movingManApparatusPanel, String string, String string2, String string3, Color color) {
        super(movingManApparatusPanel, new Range2D(0.0, -10.0, 20.0, 10.0), string, string3, color);
        this.module = movingManModule;
        this.varname = string2;
        this.getChart().getVerticalGridlines().setMajorTickSpacing(10.0);
        this.getChart().getVerticalTicks().setMajorTickSpacing(5.0);
        this.getChart().getVerticalTicks().setMinorTickSpacing(5.0);
        this.getChart().getVerticalGridlines().setMajorTickSpacing(5.0);
        this.getChart().getHorizontalTicks().setMajorTickSpacing(2.0);
        this.getChart().getHorizonalGridlines().setMajorTickSpacing(2.0);
        this.getChart().getXAxis().setMajorTickSpacing(2.0);
        movingManModule.getTimeModel().addListener(new TimeListenerAdapter(){

            public void recordingPaused() {
                MMPlot.this.setPlaybackTime(movingManModule.getTimeModel().getRecordTimer().getTime());
                MMPlot.this.setCursorVisible(true);
            }

            public void recordingStarted() {
                MMPlot.this.setCursorVisible(false);
            }

            public void recordingFinished() {
                MMPlot.this.setCursorVisible(true);
            }
        });
        this.setCursorVisible(false);
        this.addListener(new PlotDeviceListenerAdapter(){

            public void cursorDragged(double d) {
                MMPlot.this.handleCursorMoved(d);
            }
        });
        movingManModule.getTimeModel().getPlaybackTimer().addListener(new MMTimer.Listener(){

            public void timeChanged() {
                MMPlot.this.setPlaybackTime(movingManModule.getTimeModel().getPlaybackTimer().getTime());
            }
        });
        this.addListener(new PlotDeviceListenerAdapter(){

            public void bufferChanged() {
                movingManApparatusPanel.repaintBackground();
            }
        });
        movingManModule.getMan().addListener(new Man.Adapter(){

            public void collided(Man man) {
                if (movingManApparatusPanel.getGraphic().getActiveUnit() == MMPlot.this.getChartSlider().getSliderGraphic()) {
                    movingManApparatusPanel.getGraphic().clearActiveUnit();
                }
            }
        });
        this.setPaintYLines(new double[]{5.0, 10.0});
    }

    private void handleCursorMoved(double d) {
        double d2 = this.module.getTimeModel().getRecordTimer().getTime();
        if (d > d2) {
            d = d2;
        } else if (d < 0.0) {
            d = 0.0;
        }
        this.module.setReplayTime(d);
    }

    public void valueChanged(double d) {
    }

    public void updateSlider() {
    }

    public void setTextValue(double d) {
        for (int i = 0; i < this.numPlotDeviceData(); ++i) {
            PlotDeviceSeries plotDeviceSeries = this.plotDeviceSeriesAt(i);
            plotDeviceSeries.setReadoutValue(d);
        }
    }

    public String getVarname() {
        return this.varname;
    }

    public void setSelected(boolean bl) {
        this.getChartSlider().setSelected(bl);
    }
}

