/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.plots;

import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common_movingman.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common_movingman.view.phetgraphics.GraphicCriteria;
import edu.colorado.phet.common_movingman.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.ShadowHTMLGraphic;
import edu.colorado.phet.movingman.MMFontManager;
import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.model.MMTimer;
import edu.colorado.phet.movingman.plotdevice.PlotDeviceListenerAdapter;
import edu.colorado.phet.movingman.plots.MMPlot;
import edu.colorado.phet.movingman.plots.MovingManConfig;
import edu.colorado.phet.movingman.plots.SliderHelpItem;
import edu.colorado.phet.movingman.plots.TextBox;
import edu.colorado.phet.movingman.plots.TimePoint;
import edu.colorado.phet.movingman.plots.TimeSeries;
import edu.colorado.phet.movingman.view.GoPauseClearPanel;
import edu.colorado.phet.movingman.view.MovingManApparatusPanel;
import edu.colorado.phet.movingman.view.MovingManLayout;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;

public class MMPlotSuite
extends GraphicLayerSet
implements MovingManLayout.LayoutItem {
    private MMPlot plot;
    private PhetGraphic maximizeButton;
    private boolean plotVisible = true;
    private int plotInsetX = 100;
    private ArrayList listeners = new ArrayList();
    private PhetGraphic goPauseClearGraphic;
    private PhetGraphic textBoxGraphic;
    private TextBox textBox;
    private ShadowHTMLGraphic titleGraphic;
    private GoPauseClearPanel goPauseClearPanel;
    private MovingManApparatusPanel movingManApparatusPanel;
    private MovingManModule module;
    private DefaultDecimalFormat decimalFormat = new DefaultDecimalFormat("0.00");

    public MMPlotSuite(final MovingManModule movingManModule, MovingManApparatusPanel movingManApparatusPanel, MMPlot mMPlot) {
        super(movingManApparatusPanel);
        this.module = movingManModule;
        this.movingManApparatusPanel = movingManApparatusPanel;
        this.plot = mMPlot;
        mMPlot.addListener(new PlotDeviceListenerAdapter(){

            public void minimizePressed() {
                MMPlotSuite.this.setPlotVisible(false);
            }
        });
        JButton jButton = new JButton(mMPlot.getName());
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMPlotSuite.this.setPlotVisible(true);
            }
        });
        this.maximizeButton = PhetJComponent.newInstance(movingManApparatusPanel, jButton);
        this.maximizeButton.setVisible(false);
        this.addGraphic(mMPlot);
        this.addGraphic(this.maximizeButton);
        this.goPauseClearPanel = new GoPauseClearPanel(movingManApparatusPanel.getModule());
        this.goPauseClearGraphic = PhetJComponent.newInstance(movingManApparatusPanel, this.goPauseClearPanel);
        PhetGraphic phetGraphic = this.getGoButtonGraphic();
        this.addGraphic(this.goPauseClearGraphic);
        this.textBox = new TextBox(movingManApparatusPanel.getModule(), 4, mMPlot.getVarname() + "=");
        movingManModule.getTimeModel().getPlaybackTimer().addListener(new MMTimer.Listener(){

            public void timeChanged() {
                MMPlotSuite.this.setPlaybackTime(movingManModule.getTimeModel().getPlaybackTimer().getTime());
            }
        });
        this.textBoxGraphic = PhetJComponent.newInstance(movingManApparatusPanel, this.textBox);
        this.addGraphic(this.textBoxGraphic);
        mMPlot.dataSeriesAt(0).getRawData().addObserver(new TimeSeries.Observer(){

            public void dataAdded(TimeSeries timeSeries) {
                MMPlotSuite.this.setTextBoxText(timeSeries.getLastPoint().getValue());
                MMPlotSuite.this.notifyValueChanged(timeSeries.getLastPoint().getValue());
            }

            public void cleared(TimeSeries timeSeries) {
            }
        });
        this.titleGraphic = new ShadowHTMLGraphic(movingManApparatusPanel, mMPlot.getName(), MMFontManager.getFontSet().getTitleFont(), mMPlot.dataSeriesAt(0).getColor(), 1, 1, Color.black);
        this.addGraphic(this.titleGraphic);
        if (MovingManConfig.isUseSliderHelpItemReminder()) {
            SliderHelpItem sliderHelpItem = new SliderHelpItem(movingManApparatusPanel, phetGraphic, this);
            this.addGraphic(sliderHelpItem);
        }
    }

    private void setTextBoxText(double d) {
        String string = this.decimalFormat.format(d);
        this.textBox.setText(string);
    }

    public PhetGraphic getTextBoxGraphic() {
        return this.textBoxGraphic;
    }

    private void setPlaybackTime(double d) {
        if (this.plot.getNumDataSeries() > 0) {
            TimePoint timePoint = this.plot.dataSeriesAt(0).getRawData().getValueForTime(d);
            this.setTextBoxText(timePoint.getValue());
            this.notifyValueChanged(timePoint.getValue());
        }
    }

    private void notifyValueChanged(double d) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.valueChanged(d);
        }
    }

    public boolean isPaused() {
        return this.movingManApparatusPanel.getModule().isPaused();
    }

    private PhetGraphic search(PhetGraphic phetGraphic, GraphicCriteria graphicCriteria) {
        if (graphicCriteria.isSatisfied(phetGraphic)) {
            return phetGraphic;
        }
        if (phetGraphic instanceof GraphicLayerSet) {
            GraphicLayerSet graphicLayerSet = (GraphicLayerSet)phetGraphic;
            PhetGraphic[] phetGraphicArray = graphicLayerSet.getGraphics();
            for (int i = 0; i < phetGraphicArray.length; ++i) {
                PhetGraphic phetGraphic2 = phetGraphicArray[i];
                PhetGraphic phetGraphic3 = this.search(phetGraphic2, graphicCriteria);
                if (phetGraphic3 == null) continue;
                return phetGraphic3;
            }
        }
        return null;
    }

    private PhetGraphic getGoButtonGraphic() {
        GraphicCriteria graphicCriteria = new GraphicCriteria(){

            public boolean isSatisfied(PhetGraphic phetGraphic) {
                PhetJComponent phetJComponent;
                return phetGraphic instanceof PhetJComponent && (phetJComponent = (PhetJComponent)phetGraphic).getSourceComponent() == MMPlotSuite.this.goPauseClearPanel.getGoPauseButton();
            }
        };
        return this.search(this.goPauseClearGraphic, graphicCriteria);
    }

    public TextBox getTextBox() {
        return this.textBox;
    }

    public MMPlot getPlotDevice() {
        return this.plot;
    }

    public boolean isPlotVisible() {
        return this.plotVisible;
    }

    public Rectangle getBorderRectangle() {
        if (this.isPlotVisible()) {
            this.setBoundsDirty();
            Rectangle rectangle = this.textBoxGraphic.getBounds();
            rectangle = rectangle.union(this.plot.getVisibleBounds());
            rectangle = rectangle.intersection(new Rectangle(this.getComponent().getSize()));
            return rectangle;
        }
        return null;
    }

    public void valueChanged(double d) {
        this.plot.setTextValue(d);
        this.setTextBoxText(d);
        this.notifyValueChanged(d);
    }

    public void reset() {
        this.plot.reset();
        this.valueChanged(0.0);
    }

    public GoPauseClearPanel getGoPauseClearPanel() {
        return this.goPauseClearPanel;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void setPlotVisible(boolean bl) {
        if (bl != this.plotVisible) {
            this.plotVisible = bl;
            this.plot.setVisible(bl);
            this.goPauseClearGraphic.setVisible(bl);
            this.textBoxGraphic.setVisible(bl);
            this.titleGraphic.setVisible(bl);
            this.maximizeButton.setVisible(!bl);
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener listener = (Listener)this.listeners.get(i);
                listener.plotVisibilityChanged();
            }
            this.fireVisibilityChanged();
        }
    }

    public boolean isVariable() {
        return this.plotVisible;
    }

    public int getLayoutHeight() {
        return this.maximizeButton.getHeight();
    }

    public void setVerticalParameters(int n, int n2) {
        this.titleGraphic.setLocation(2, n);
        this.textBoxGraphic.setLocation(2, n + 20);
        this.goPauseClearGraphic.setLocation(10, this.textBoxGraphic.getHeight() + this.textBoxGraphic.getY() + 5);
        if (this.getComponent().getWidth() > 0 && n2 > 0) {
            int n3 = 10;
            int n4 = this.plot.getChartSlider().getWidth() * 2;
            int n5 = this.getComponent().getWidth() - this.textBoxGraphic.getWidth() - n3 * 2 - n4;
            this.plot.setChartSize(n5, n2);
            this.plot.setLocation((int)(this.textBoxGraphic.getBounds().getMaxX() + (double)n3 + (double)n4), n);
        }
        this.setBoundsDirty();
        this.autorepaint();
        this.notifyChanged();
    }

    public void setY(int n) {
        this.maximizeButton.setLocation(this.plotInsetX, n);
    }

    public static interface Listener {
        public void plotVisibilityChanged();

        public void valueChanged(double var1);
    }
}

