/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.plots;

import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.model.Man;
import edu.colorado.phet.movingman.plots.PlotSet;

public abstract class ManValueChange {
    PlotSet plotSet;
    MovingManModule module;

    protected ManValueChange(MovingManModule movingManModule, PlotSet plotSet) {
        this.module = movingManModule;
        this.plotSet = plotSet;
    }

    abstract void setValue(Man var1, double var2);

    public static class AccelerationChange
    extends ManValueChange {
        public AccelerationChange(MovingManModule movingManModule, PlotSet plotSet) {
            super(movingManModule, plotSet);
        }

        void setValue(Man man, double d) {
            man.setAcceleration(d);
            this.plotSet.getAccelerationPlotSuite().valueChanged(d);
            this.plotSet.notifyAccelerationControlMode();
        }
    }

    public static class VelocityChange
    extends ManValueChange {
        public VelocityChange(MovingManModule movingManModule, PlotSet plotSet) {
            super(movingManModule, plotSet);
        }

        void setValue(Man man, double d) {
            if (!this.module.isPaused()) {
                man.setAcceleration(0.0);
            }
            man.setVelocity(d);
            this.plotSet.getVelocityPlotSuite().valueChanged(d);
            this.plotSet.notifyVelocityControlMode();
        }
    }

    public static class PositionChange
    extends ManValueChange {
        public PositionChange(MovingManModule movingManModule, PlotSet plotSet) {
            super(movingManModule, plotSet);
        }

        public void setValue(Man man, double d) {
            if (!this.module.isPaused()) {
                man.setAcceleration(0.0);
                man.setVelocity(0.0);
            }
            man.setPosition(d);
            this.plotSet.getPositionPlotSuite().valueChanged(d);
            this.plotSet.notifyPositionControlMode();
        }
    }
}

