/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.plots;

import edu.colorado.phet.chart_movingman.Range2D;
import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.movingman.MMFontManager;
import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.model.Man;
import edu.colorado.phet.movingman.model.MovingManModel;
import edu.colorado.phet.movingman.plotdevice.PlotDeviceListenerAdapter;
import edu.colorado.phet.movingman.plotdevice.PlotDeviceSeries;
import edu.colorado.phet.movingman.plots.MMPlot;
import edu.colorado.phet.movingman.plots.MMPlotSuite;
import edu.colorado.phet.movingman.plots.ManValueChange;
import edu.colorado.phet.movingman.plots.TextBox;
import edu.colorado.phet.movingman.view.GoPauseClearPanel;
import edu.colorado.phet.movingman.view.MovingManApparatusPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;

public class PlotSet {
    private MMPlotSuite positionSuite;
    private MMPlotSuite velSuite;
    private MMPlotSuite accSuite;
    private MovingManModule module;
    private MovingManModel movingManModel;
    private MovingManApparatusPanel movingManApparatusPanel;
    private Font readoutFont = MMFontManager.getFontSet().getReadoutFont();
    private ArrayList listeners = new ArrayList();

    public PlotSet(final MovingManModule movingManModule, final MovingManApparatusPanel movingManApparatusPanel) {
        this.movingManApparatusPanel = movingManApparatusPanel;
        this.movingManModel = movingManModule.getMovingManModel();
        this.module = movingManModule;
        double d = 12.0;
        double d2 = 12.0;
        double d3 = 12.0;
        BasicStroke basicStroke = new BasicStroke(3.0f, 1, 1);
        final MMPlot mMPlot = new MMPlot(movingManModule, movingManApparatusPanel, SimStrings.get("variables.position"), SimStrings.get("variables.position.abbreviation"), "moving-man/images/blue-arrow.png", Color.blue);
        mMPlot.setChartRange(new Range2D(this.movingManModel.getMinTime(), -d, this.movingManModel.getMaxTime(), d));
        PlotDeviceSeries plotDeviceSeries = new PlotDeviceSeries(mMPlot, movingManModule.getMovingManModel().getPositionDataSuite().getSmoothedDataSeries(), Color.blue, SimStrings.get("variables.position"), basicStroke, this.readoutFont, SimStrings.get("units.meters.abbreviation"), "-99.9");
        mMPlot.addPlotDeviceData(plotDeviceSeries);
        ManValueChange.PositionChange positionChange = new ManValueChange.PositionChange(movingManModule, this);
        ManValueChange.VelocityChange velocityChange = new ManValueChange.VelocityChange(movingManModule, this);
        ManValueChange.AccelerationChange accelerationChange = new ManValueChange.AccelerationChange(movingManModule, this);
        final SliderHandler sliderHandler = new SliderHandler(movingManModule, positionChange){

            public void valueChanged(double d) {
                if (d < -10.0) {
                    d = -10.0;
                }
                if (d > 10.0) {
                    d = 10.0;
                }
                super.valueChanged(d);
            }
        };
        mMPlot.addListener(new PlotDeviceListenerAdapter(){

            public void sliderDragged(double d) {
                sliderHandler.valueChanged(d);
            }
        });
        final MMPlot mMPlot2 = new MMPlot(movingManModule, movingManApparatusPanel, SimStrings.get("variables.velocity"), SimStrings.get("variables.velocity.abbreviation"), "moving-man/images/red-arrow.png", Color.red);
        PlotDeviceSeries plotDeviceSeries2 = new PlotDeviceSeries(mMPlot2, movingManModule.getMovingManModel().getVelocitySeries().getSmoothedDataSeries(), Color.red, SimStrings.get("variables.velocity"), basicStroke, this.readoutFont, SimStrings.get("units.velocity.abbreviation"), "-99.9");
        mMPlot2.addPlotDeviceData(plotDeviceSeries2);
        mMPlot2.setChartRange(new Range2D(this.movingManModel.getMinTime(), -d2, this.movingManModel.getMaxTime(), d2));
        final SliderHandler sliderHandler2 = new SliderHandler(movingManModule, velocityChange);
        mMPlot2.addListener(new PlotDeviceListenerAdapter(){

            public void sliderDragged(double d) {
                sliderHandler2.valueChanged(d);
            }
        });
        final MMPlot mMPlot3 = new MMPlot(movingManModule, movingManApparatusPanel, SimStrings.get("variables.acceleration"), SimStrings.get("variables.acceleration.abbreviation"), "moving-man/images/green-arrow.png", Color.green);
        Color color = new Color(40, 165, 50);
        mMPlot3.addPlotDeviceData(new PlotDeviceSeries(mMPlot3, movingManModule.getMovingManModel().getAccelerationDataSuite().getSmoothedDataSeries(), color, SimStrings.get("variables.acceleration"), basicStroke, this.readoutFont, SimStrings.get("units.acceleration.abbreviation"), "-999.9"));
        mMPlot3.setChartRange(new Range2D(this.movingManModel.getMinTime(), -d3, this.movingManModel.getMaxTime(), d3));
        final SliderHandler sliderHandler3 = new SliderHandler(movingManModule, accelerationChange);
        mMPlot3.addListener(new PlotDeviceListenerAdapter(){

            public void sliderDragged(double d) {
                System.out.println("dragValue = " + d);
                sliderHandler3.valueChanged(d);
            }
        });
        movingManModule.getMan().addListener(new Man.Adapter(){

            public void positionChanged(double d) {
                if (movingManModule.isPaused()) {
                    mMPlot.valueChanged(d);
                }
            }

            public void velocityChanged(double d) {
                if (movingManModule.isPaused()) {
                    mMPlot2.valueChanged(d);
                }
            }

            public void accelerationChanged(double d) {
                if (movingManModule.isPaused()) {
                    mMPlot3.valueChanged(d);
                }
            }
        });
        this.positionSuite = new MMPlotSuite(movingManModule, movingManApparatusPanel, mMPlot);
        this.velSuite = new MMPlotSuite(movingManModule, movingManApparatusPanel, mMPlot2);
        this.accSuite = new MMPlotSuite(movingManModule, movingManApparatusPanel, mMPlot3);
        this.positionSuite.getTextBox().addKeyListener(new TextHandler(this.positionSuite.getTextBox(), movingManModule, positionChange));
        this.accSuite.getTextBox().addKeyListener(new TextHandler(this.accSuite.getTextBox(), movingManModule, accelerationChange));
        this.velSuite.getTextBox().addKeyListener(new TextHandler(this.velSuite.getTextBox(), movingManModule, velocityChange));
        MMPlotSuite.Listener listener = new MMPlotSuite.Listener(){

            public void plotVisibilityChanged() {
                movingManApparatusPanel.relayout();
            }

            public void valueChanged(double d) {
            }
        };
        this.positionSuite.addListener(listener);
        this.velSuite.addListener(listener);
        this.accSuite.addListener(listener);
        PlotDeviceListenerAdapter plotDeviceListenerAdapter = new PlotDeviceListenerAdapter(){

            public void maxTimeChanged(double d) {
                mMPlot.setMaxTime(d);
                mMPlot2.setMaxTime(d);
                mMPlot3.setMaxTime(d);
            }
        };
        mMPlot.addListener(plotDeviceListenerAdapter);
        mMPlot2.addListener(plotDeviceListenerAdapter);
        mMPlot3.addListener(plotDeviceListenerAdapter);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public MMPlotSuite getPlotSuiteFor(GoPauseClearPanel goPauseClearPanel) {
        if (this.positionSuite.getGoPauseClearPanel() == goPauseClearPanel) {
            return this.positionSuite;
        }
        if (this.velSuite.getGoPauseClearPanel() == goPauseClearPanel) {
            return this.velSuite;
        }
        if (this.accSuite.getGoPauseClearPanel() == goPauseClearPanel) {
            return this.accSuite;
        }
        return null;
    }

    public MMPlotSuite[] getOtherPlots(MMPlotSuite mMPlotSuite) {
        ArrayList<MMPlotSuite> arrayList = new ArrayList<MMPlotSuite>();
        if (mMPlotSuite != this.positionSuite) {
            arrayList.add(this.positionSuite);
        }
        if (mMPlotSuite != this.velSuite) {
            arrayList.add(this.velSuite);
        }
        if (mMPlotSuite != this.accSuite) {
            arrayList.add(this.accSuite);
        }
        return arrayList.toArray(new MMPlotSuite[0]);
    }

    void notifyAccelerationControlMode() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.setAccelerationControlMode();
        }
    }

    void notifyVelocityControlMode() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.setVelocityControlMode();
        }
    }

    void notifyPositionControlMode() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.setPositionControlMode();
        }
    }

    public MMPlot getAccelerationPlot() {
        return this.accSuite.getPlotDevice();
    }

    public MMPlot getPositionPlot() {
        return this.positionSuite.getPlotDevice();
    }

    public MMPlot getVelocityPlot() {
        return this.velSuite.getPlotDevice();
    }

    public void updateSliders() {
        this.getPositionPlot().updateSlider();
        this.getVelocityPlot().updateSlider();
        this.getAccelerationPlot().updateSlider();
    }

    public void setCursorsVisible(boolean bl) {
        this.getPositionPlot().setCursorVisible(bl);
        this.getVelocityPlot().setCursorVisible(bl);
        this.getAccelerationPlot().setCursorVisible(bl);
    }

    public void reset() {
        this.positionSuite.reset();
        this.velSuite.reset();
        this.accSuite.reset();
    }

    public void enterTextBoxValues() {
        double d;
        String string;
        if (this.positionSuite.getTextBox().isChangedByUser()) {
            try {
                string = this.positionSuite.getTextBox().getText();
                d = Double.parseDouble(string);
                this.module.getMan().setPosition(d);
            }
            catch (NumberFormatException numberFormatException) {
                this.getPositionPlot().setTextValue(this.module.getMan().getPosition());
            }
            this.positionSuite.getTextBox().clearChangedByUser();
        }
        if (this.velSuite.getTextBox().isChangedByUser()) {
            try {
                string = this.velSuite.getTextBox().getText();
                d = Double.parseDouble(string);
                this.module.getMan().setVelocity(d);
            }
            catch (NumberFormatException numberFormatException) {
                this.getPositionPlot().setTextValue(this.module.getMan().getPosition());
            }
            this.velSuite.getTextBox().clearChangedByUser();
        }
        if (this.accSuite.getTextBox().isChangedByUser()) {
            try {
                string = this.accSuite.getTextBox().getText();
                d = Double.parseDouble(string);
                this.module.getMan().setAcceleration(d);
            }
            catch (NumberFormatException numberFormatException) {
                this.getPositionPlot().setTextValue(this.module.getMan().getPosition());
            }
            this.accSuite.getTextBox().clearChangedByUser();
        }
    }

    public MMPlotSuite getPositionPlotSuite() {
        return this.positionSuite;
    }

    public MMPlotSuite getVelocityPlotSuite() {
        return this.velSuite;
    }

    public MMPlotSuite getAccelerationPlotSuite() {
        return this.accSuite;
    }

    public static class TextHandler
    implements KeyListener {
        TextBox textBox;
        MovingManModule module;
        ManValueChange manValueChange;

        public TextHandler(TextBox textBox, MovingManModule movingManModule, ManValueChange manValueChange) {
            this.textBox = textBox;
            this.module = movingManModule;
            this.manValueChange = manValueChange;
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                String string = this.textBox.getText();
                double d = Double.parseDouble(string);
                this.manValueChange.setValue(this.module.getMan(), d);
                this.module.setSmoothingSharp();
            }
        }
    }

    static class SliderHandler {
        private MovingManModule module;
        ManValueChange manValueChange;

        public SliderHandler(MovingManModule movingManModule, ManValueChange manValueChange) {
            this.module = movingManModule;
            this.manValueChange = manValueChange;
        }

        public void valueChanged(double d) {
            this.module.setRecordMode();
            this.manValueChange.setValue(this.module.getMan(), d);
            this.module.setSmoothingSmooth();
        }
    }

    public static interface Listener {
        public void setAccelerationControlMode();

        public void setVelocityControlMode();

        public void setPositionControlMode();
    }
}

