/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.plots;

import edu.colorado.phet.common_movingman.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.common.HelpItem2;
import edu.colorado.phet.movingman.model.TimeListenerAdapter;
import edu.colorado.phet.movingman.plotdevice.PlotDeviceListenerAdapter;
import edu.colorado.phet.movingman.plots.MMPlotSuite;
import edu.colorado.phet.movingman.view.MovingManApparatusPanel;

public class SliderHelpItem
extends HelpItem2 {
    private boolean shown = false;
    private MovingManApparatusPanel movingManApparatusPanel;

    public SliderHelpItem(MovingManApparatusPanel movingManApparatusPanel, PhetGraphic phetGraphic, final MMPlotSuite mMPlotSuite) {
        super(movingManApparatusPanel, "Press Go!");
        this.movingManApparatusPanel = movingManApparatusPanel;
        this.setVisible(false);
        this.pointLeftAt(phetGraphic, 30);
        movingManApparatusPanel.getModule().getMovingManModel().getTimeModel().addListener(new TimeListenerAdapter(){

            public void recordingStarted() {
                SliderHelpItem.this.hideGoHelp();
            }

            public void playbackStarted() {
                SliderHelpItem.this.hideGoHelp();
            }

            public void rewind() {
                SliderHelpItem.this.hideGoHelp();
            }

            public void reset() {
                SliderHelpItem.this.hideGoHelp();
            }
        });
        mMPlotSuite.getPlotDevice().addListener(new PlotDeviceListenerAdapter(){

            public void sliderDragged(double d) {
                if (mMPlotSuite.isPaused() && !SliderHelpItem.this.isAtEndOfTime()) {
                    SliderHelpItem.this.showSliderHelp();
                }
            }
        });
    }

    private boolean isAtEndOfTime() {
        return this.getModule().isAtEndOfTime();
    }

    private MovingManModule getModule() {
        return this.movingManApparatusPanel.getModule();
    }

    public void hideGoHelp() {
        this.setVisible(false);
    }

    private void showSliderHelp() {
        if (!this.shown) {
            this.shown = true;
            this.setVisible(true);
        }
    }
}

