/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.plots;

import edu.colorado.phet.movingman.MMFontManager;
import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.model.TimeListener;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TextBox
extends JPanel {
    static Font font = MMFontManager.getFontSet().getTextBoxFont();
    private boolean changedByUser;
    private JTextField textField;
    private JLabel label;
    private MovingManModule module;

    public TextBox(MovingManModule movingManModule, int n, String string) {
        this.module = movingManModule;
        this.textField = new JTextField(n);
        this.label = new JLabel(string);
        this.setLayout(new FlowLayout(1));
        this.textField.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (TextBox.this.isEnabled()) {
                    TextBox.this.textField.selectAll();
                }
            }
        });
        this.textField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                TextBox.this.textField.select(0, 0);
            }
        });
        this.textField.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
                TextBox.this.changedByUser = true;
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.label.setFont(font);
        this.textField.setFont(font);
        this.add(this.label);
        this.add(this.textField);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        movingManModule.addListener(new TimeListener(){

            public void recordingStarted() {
                TextBox.this.setTextFieldEditable(false);
            }

            public void recordingPaused() {
                TextBox.this.setTextFieldEditable(true);
            }

            public void recordingFinished() {
                TextBox.this.setTextFieldEditable(false);
            }

            public void playbackStarted() {
                TextBox.this.setTextFieldEditable(false);
            }

            public void playbackPaused() {
                TextBox.this.setTextFieldEditable(true);
            }

            public void playbackFinished() {
                TextBox.this.setTextFieldEditable(false);
            }

            public void reset() {
                TextBox.this.setTextFieldEditable(true);
            }

            public void rewind() {
                TextBox.this.setTextFieldEditable(true);
            }
        });
        this.setText("0.0");
        this.textField.setHorizontalAlignment(4);
    }

    public void setTextFieldEditable(boolean bl) {
        this.textField.setEditable(bl);
    }

    public void clearChangedByUser() {
        this.changedByUser = false;
    }

    public boolean isChangedByUser() {
        return this.changedByUser;
    }

    public synchronized void addKeyListener(KeyListener keyListener) {
        this.textField.addKeyListener(keyListener);
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setText(String string) {
        if (!this.textField.getText().equals(string)) {
            this.textField.setText(string);
        }
    }

    public void selectAll() {
        this.textField.selectAll();
    }

    public void deselectAll() {
        this.textField.select(0, 0);
    }

    public JTextField getTextField() {
        return this.textField;
    }
}

