/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.plots;

import edu.colorado.phet.movingman.plots.TimePoint;
import java.util.ArrayList;

public class TimeSeries {
    private ArrayList pts = new ArrayList();
    private ArrayList observers = new ArrayList();

    public void addPoint(double d, double d2) {
        TimePoint timePoint = new TimePoint(d, d2);
        this.pts.add(timePoint);
        this.notifyAdded();
    }

    private void notifyAdded() {
        for (int i = 0; i < this.observers.size(); ++i) {
            Observer observer = (Observer)this.observers.get(i);
            observer.dataAdded(this);
        }
    }

    public TimePoint getLastPoint() {
        return this.lastPointAt(0);
    }

    public int size() {
        return this.pts.size();
    }

    public void reset() {
        this.pts = new ArrayList();
        this.notifyCleared();
    }

    private void notifyCleared() {
        for (int i = 0; i < this.observers.size(); ++i) {
            Observer observer = (Observer)this.observers.get(i);
            observer.cleared(this);
        }
    }

    public TimePoint lastPointAt(int n) {
        return this.pointAt(this.pts.size() - 1 - n);
    }

    public TimePoint pointAt(int n) {
        return (TimePoint)this.pts.get(n);
    }

    public void addObserver(Observer observer) {
        this.observers.add(observer);
    }

    public int numPoints() {
        return this.pts.size();
    }

    public TimePoint getValueForTime(double d) {
        double d2;
        if (this.numPoints() == 0) {
            return new TimePoint(0.0, 0.0);
        }
        TimePoint[] timePointArray = this.getNeighborsForTime(d, 0, this.numPoints() - 1, 0);
        TimePoint timePoint = timePointArray[0];
        TimePoint timePoint2 = timePointArray[1];
        boolean bl = false;
        if (bl) {
            TimePoint timePoint3 = TimePoint.average(new TimePoint[]{timePoint, timePoint2});
            TimePoint timePoint4 = new TimePoint(timePoint3.getValue(), d);
            System.out.println("Requested time: " + d + ", lower=" + timePoint.getTime() + ", upper=" + timePoint2.getTime() + ", actualAvg=" + timePoint3.getTime() + ", fakeAverage=" + timePoint4);
            return timePoint4;
        }
        double d3 = Math.abs(timePoint.getTime() - d);
        if (d3 <= (d2 = Math.abs(timePoint2.getTime() - d))) {
            return new TimePoint(timePoint.getValue(), d);
        }
        return new TimePoint(timePoint2.getValue(), d);
    }

    private TimePoint[] getNeighborsForTime(double d, int n, int n2, int n3) {
        return new TimePoint[]{this.getLowerSample(d, n, n2, 0), this.getUpperSample(d, n, n2, 0)};
    }

    private TimePoint getLowerSample(double d, int n, int n2, int n3) {
        if (n3 > 1000) {
            new RuntimeException("Lower Sample recursed 1000 times.").printStackTrace();
            return new TimePoint(0.0, 0.0);
        }
        if (n == n2 || n == n2 - 1) {
            return this.pointAt(n);
        }
        int n4 = (n2 + n) / 2;
        TimePoint timePoint = this.pointAt(n4);
        if (timePoint.getTime() > d) {
            return this.getLowerSample(d, n, n4, n3 + 1);
        }
        return this.getLowerSample(d, n4, n2, n3 + 1);
    }

    private TimePoint getUpperSample(double d, int n, int n2, int n3) {
        if (n3 > 1000) {
            new RuntimeException("Lower Sample recursed 1000 times.").printStackTrace();
            return new TimePoint(0.0, 0.0);
        }
        if (n == n2 || n == n2 - 1) {
            return this.pointAt(n2);
        }
        int n4 = (n2 + n) / 2;
        TimePoint timePoint = this.pointAt(n4);
        if (timePoint.getTime() > d) {
            return this.getUpperSample(d, n, n4, n3 + 1);
        }
        return this.getUpperSample(d, n4, n2, n3 + 1);
    }

    public TimePoint getLatestDerivative(double d) {
        if (this.size() > 2) {
            double d2 = this.lastPointAt(0).getValue();
            double d3 = this.lastPointAt(2).getValue();
            double d4 = d2 - d3;
            double d5 = this.lastPointAt(0).getTime() - this.lastPointAt(2).getTime();
            double d6 = d4 / d5;
            double d7 = (this.lastPointAt(0).getTime() + this.lastPointAt(2).getTime()) / 2.0;
            return new TimePoint(d6, d7);
        }
        return null;
    }

    public static interface Observer {
        public void dataAdded(TimeSeries var1);

        public void cleared(TimeSeries var1);
    }
}

