/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.view;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_movingman.math.Vector2D;
import edu.colorado.phet.common_movingman.view.graphics.shapes.Arrow;
import edu.colorado.phet.common_movingman.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetShadowTextGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.plots.MMPlotSuite;
import edu.colorado.phet.movingman.view.ManGraphic;
import edu.colorado.phet.movingman.view.MovingManApparatusPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class ArrowSetGraphic
extends CompositePhetGraphic {
    private MovingManModule movingManModule;
    private ManGraphic manGraphic;
    private ForceArrowGraphic vel;
    private ForceArrowGraphic accel;
    private double arrowTailWidth = 30.0;
    private double arrowHeadHeight = 55.0;
    private double v = 0.0;
    private double a = 0.0;

    public ArrowSetGraphic(MovingManModule movingManModule, MovingManApparatusPanel movingManApparatusPanel, ManGraphic manGraphic) {
        super(movingManApparatusPanel);
        this.movingManModule = movingManModule;
        this.manGraphic = manGraphic;
        this.vel = new ForceArrowGraphic(movingManApparatusPanel, SimStrings.get("variables.velocity"), Color.red, 0, new ForceComponent(){

            public double getValue() {
                return ArrowSetGraphic.this.getVelocity();
            }
        });
        this.accel = new ForceArrowGraphic(movingManApparatusPanel, SimStrings.get("variables.acceleration"), Color.green, 0, new ForceComponent(){

            public double getValue() {
                return ArrowSetGraphic.this.getAcceleration();
            }
        });
        this.addGraphic(this.accel);
        this.addGraphic(this.vel);
        movingManApparatusPanel.getPlotSet().getVelocityPlotSuite().addListener(new MMPlotSuite.Listener(){

            public void plotVisibilityChanged() {
            }

            public void valueChanged(double d) {
                ArrowSetGraphic.this.v = d;
            }
        });
        movingManApparatusPanel.getPlotSet().getAccelerationPlotSuite().addListener(new MMPlotSuite.Listener(){

            public void plotVisibilityChanged() {
            }

            public void valueChanged(double d) {
                ArrowSetGraphic.this.a = d;
            }
        });
    }

    public void paint(Graphics2D graphics2D) {
        super.paint(graphics2D);
    }

    private double getAcceleration() {
        if (Math.abs(this.a) < 0.1) {
            return 0.0;
        }
        return this.a;
    }

    private double getVelocity() {
        if (Math.abs(this.v) < 0.1) {
            return 0.0;
        }
        return this.v;
    }

    public void setShowAccelerationVector(boolean bl) {
        this.accel.setVisible(bl);
    }

    public void setShowVelocityVector(boolean bl) {
        this.vel.setVisible(bl);
    }

    private double getLengthScale() {
        if (this.manGraphic.getManTransform().getMinInput() < this.manGraphic.getManTransform().getMaxInput()) {
            return 10.0;
        }
        return -10.0;
    }

    private void updateForceArrows() {
        this.accel.update();
        this.vel.update();
        this.checkTextOverlap();
    }

    private void checkTextOverlap() {
        Rectangle rectangle;
        Rectangle rectangle2;
        if (this.accel.textGraphic.isVisible() && this.vel.textGraphic.isVisible() && (rectangle2 = this.accel.textGraphic.getBounds()).intersects(rectangle = this.vel.textGraphic.getBounds())) {
            Rectangle rectangle3 = rectangle2.intersection(rectangle);
            int n = rectangle3.width;
            int n2 = n / 2 + 5;
            if (rectangle2.x < rectangle.x) {
                this.accel.textGraphic.setLocation(rectangle2.x - n2, this.accel.textGraphic.getY());
                this.vel.textGraphic.setLocation(rectangle.x + n2, this.vel.textGraphic.getY());
            } else {
                this.accel.textGraphic.setLocation(rectangle2.x + n2, this.accel.textGraphic.getY());
                this.vel.textGraphic.setLocation(rectangle.x - n2, this.vel.textGraphic.getY());
            }
        }
    }

    public void updateGraphics() {
        this.updateForceArrows();
    }

    class ForceArrowGraphic
    extends CompositePhetGraphic {
        private String name;
        private Color color;
        private int dy;
        private ForceComponent forceComponent;
        PhetShadowTextGraphic textGraphic;
        PhetShapeGraphic shapeGraphic;
        final Font font;
        private Arrow lastArrow;

        public ForceArrowGraphic(Component component, String string, Color color, int n, ForceComponent forceComponent) {
            super(component);
            this.font = new Font("Lucida Sans", 1, 13);
            this.name = string;
            this.color = color = this.transparify(color, 128);
            this.dy = n;
            this.forceComponent = forceComponent;
            this.textGraphic = new PhetShadowTextGraphic(component, this.font, string, Color.black, 1, 1, Color.yellow);
            this.shapeGraphic = new PhetShapeGraphic(component, null, color, new BasicStroke(1.0f), Color.black);
            this.addGraphic(this.shapeGraphic);
            this.addGraphic(this.textGraphic);
            this.update();
        }

        private Color transparify(Color color, int n) {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
        }

        public void update() {
            double d = this.forceComponent.getValue();
            if (d == 0.0) {
                this.textGraphic.setVisible(false);
                this.shapeGraphic.setVisible(false);
                return;
            }
            this.shapeGraphic.setVisible(true);
            this.textGraphic.setVisible(true);
            double d2 = d * ArrowSetGraphic.this.getLengthScale();
            Point point = ArrowSetGraphic.this.manGraphic.getCenter();
            point.y += ((ArrowSetGraphic)ArrowSetGraphic.this).manGraphic.getBounds().height / 2;
            point.y -= this.dy;
            Point2D.Double double_ = new Point2D.Double(point.x, point.y);
            Point2D point2D = new Vector2D.Double(d2, 0.0).getDestination(double_);
            Arrow arrow = new Arrow(double_, point2D, ArrowSetGraphic.this.arrowHeadHeight, ArrowSetGraphic.this.arrowHeadHeight, ArrowSetGraphic.this.arrowTailWidth, 0.5, false);
            GeneralPath generalPath = arrow.getShape();
            this.shapeGraphic.setShape(generalPath);
            GeneralPath generalPath2 = arrow.getTailShape();
            double d3 = this.textGraphic.getHeight();
            double d4 = generalPath2.getBounds().getHeight();
            double d5 = generalPath2.getBounds().getY() + d4 / 2.0 - d3 / 2.0;
            this.textGraphic.setLocation(generalPath2.getBounds().x, (int)d5);
            this.lastArrow = arrow;
            this.setBoundsDirty();
            this.autorepaint();
        }
    }

    static interface ForceComponent {
        public double getValue();
    }
}

