/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.view;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_movingman.view.components.VerticalLayoutPanel;
import edu.colorado.phet.common_movingman.view.util.ImageLoader;
import edu.colorado.phet.movingman.MMFontManager;
import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.model.TimeListenerAdapter;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class GoPauseClearPanel
extends VerticalLayoutPanel {
    private MovingManModule module;
    private JButton goPauseButton;
    private JButton resetButton;
    private boolean itsAGoButton = true;
    private ImageIcon goIcon;
    private ImageIcon pauseIcon;

    public GoPauseClearPanel(final MovingManModule movingManModule) {
        this.module = movingManModule;
        super.getGridBagConstraints().anchor = 10;
        final ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                movingManModule.setPaused(true);
                movingManModule.requestEditInTextBox(GoPauseClearPanel.this);
            }
        };
        this.goPauseButton = new ControlButton(SimStrings.get("plot.pause"));
        try {
            this.goIcon = new ImageIcon(ImageLoader.loadBufferedImage("moving-man/images/light3.png"));
            this.pauseIcon = new ImageIcon(ImageLoader.loadBufferedImage("moving-man/images/stop-20.png"));
            this.goPauseButton.setIcon(this.goIcon);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        final ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                movingManModule.setRecordMode();
                movingManModule.setPaused(false);
            }
        };
        this.goPauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GoPauseClearPanel.this.itsAGoButton) {
                    actionListener2.actionPerformed(actionEvent);
                } else {
                    actionListener.actionPerformed(actionEvent);
                }
            }
        });
        this.resetButton = new ControlButton(SimStrings.get("plot.clear"));
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                movingManModule.confirmAndApplyReset();
            }
        });
        movingManModule.addListener(new TimeListenerAdapter(){

            public void recordingStarted() {
                GoPauseClearPanel.this.setButtons(false, true, true);
            }

            public void recordingPaused() {
                GoPauseClearPanel.this.setButtons(true, false, true);
            }

            public void recordingFinished() {
                GoPauseClearPanel.this.setButtons(false, false, true);
            }

            public void reset() {
                GoPauseClearPanel.this.setButtons(true, false, false);
            }

            public void rewind() {
                GoPauseClearPanel.this.setButtons(true, false, true);
            }
        });
        this.add(this.goPauseButton);
        this.add(this.resetButton);
        this.setButtons(true, false, false);
    }

    private void setButtons(boolean bl, boolean bl2, boolean bl3) {
        if (bl2 && bl || bl2 || !bl) {
            // empty if block
        }
        if (bl2) {
            this.goPauseButton.setText(SimStrings.get("plot.pause"));
            this.goPauseButton.setIcon(this.pauseIcon);
            super.invalidate();
            super.validate();
            super.doLayout();
            this.itsAGoButton = false;
        } else {
            this.goPauseButton.setText("      " + SimStrings.get("plot.go"));
            this.goPauseButton.setIcon(this.goIcon);
            super.invalidate();
            super.validate();
            super.doLayout();
            this.itsAGoButton = true;
        }
        this.resetButton.setEnabled(bl3);
    }

    public JButton getGoPauseButton() {
        return this.goPauseButton;
    }

    static class ControlButton
    extends JButton {
        static Font font = MMFontManager.getFontSet().getControlButtonFont();

        public ControlButton(String string) {
            super(string);
            this.setFont(font);
        }
    }
}

