/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.view;

import edu.colorado.phet.common_movingman.model.Command;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_movingman.view.util.BufferedImageUtils;
import edu.colorado.phet.common_movingman.view.util.ImageLoader;
import edu.colorado.phet.common_movingman.view.util.RectangleUtils;
import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.common.LinearTransform1d;
import edu.colorado.phet.movingman.model.Man;
import edu.colorado.phet.movingman.view.MovingManApparatusPanel;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.event.MouseInputListener;

public class ManGraphic
extends PhetGraphic
implements MouseInputListener {
    private BufferedImage standingMan;
    private BufferedImage leftMan;
    private BufferedImage rightMan;
    private int x;
    private int y;
    private LinearTransform1d transform;
    private LinearTransform1d inversion;
    private MovingManModule module;
    private Man m;
    private DragHandler dragHandler;
    private BufferedImage currentImage;
    private ArrayList listeners = new ArrayList();
    private int lastX;
    private MovingManApparatusPanel apparatusPanel;

    public ManGraphic(MovingManModule movingManModule, MovingManApparatusPanel movingManApparatusPanel, Man man, int n, LinearTransform1d linearTransform1d) throws IOException {
        super(movingManApparatusPanel);
        this.apparatusPanel = movingManApparatusPanel;
        this.module = movingManModule;
        this.m = man;
        this.y = n;
        this.transform = linearTransform1d;
        this.standingMan = ImageLoader.loadBufferedImage("moving-man/images/stand-ii.gif");
        this.leftMan = ImageLoader.loadBufferedImage("moving-man/images/left-ii.gif");
        int n2 = 120;
        this.standingMan = BufferedImageUtils.rescaleYMaintainAspectRatio(movingManApparatusPanel, this.standingMan, n2);
        this.leftMan = BufferedImageUtils.rescaleYMaintainAspectRatio(movingManApparatusPanel, this.leftMan, n2);
        this.rightMan = BufferedImageUtils.flipX(this.leftMan);
        this.currentImage = this.standingMan;
        man.addListener(new Man.Adapter(){

            public void positionChanged(double d) {
                ManGraphic.this.positionChanged();
            }
        });
        this.inversion = linearTransform1d.getInvertedInstance();
        this.positionChanged();
        this.addMouseInputListener(this);
    }

    public void paint(Graphics2D graphics2D) {
        int n = this.x - this.currentImage.getWidth() / 2;
        graphics2D.drawImage((Image)this.currentImage, n, this.y, this.apparatusPanel);
    }

    public void positionChanged() {
        Rectangle rectangle = this.getRectangle();
        double d = this.transform.transform(this.m.getPosition());
        this.lastX = this.x;
        this.x = (int)d;
        if (this.lastX != this.x) {
            double d2 = this.getDx();
            if (d2 != 0.0) {
                this.setVelocity(d2);
            }
            this.doRepaint(rectangle);
        }
        this.setBoundsDirty();
        this.autorepaint();
    }

    private void doRepaint(Rectangle rectangle) {
        this.repaint(rectangle, this.getRectangle());
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.manGraphicChanged();
        }
    }

    private void repaint(Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = rectangle.union(rectangle2);
        this.apparatusPanel.repaint(rectangle3);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dragHandler = new DragHandler(mouseEvent.getPoint(), new Point(this.x, this.y));
        this.module.getModel().execute(new Command(){

            public void doIt() {
                ManGraphic.this.m.setGrabbed(true);
            }
        });
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void setVelocity(double d) {
        Rectangle rectangle = this.getRectangle();
        BufferedImage bufferedImage = this.currentImage;
        if (d == 0.0 && this.currentImage != this.standingMan) {
            this.currentImage = this.standingMan;
        } else if (d < 0.0 && this.currentImage != this.leftMan) {
            this.currentImage = this.leftMan;
        } else if (d > 0.0 && this.currentImage != this.rightMan) {
            this.currentImage = this.rightMan;
        }
        if (this.currentImage != bufferedImage) {
            this.doRepaint(rectangle);
        }
    }

    public double getDx() {
        return this.x - this.lastX;
    }

    public Point getCenter() {
        return RectangleUtils.getCenter(this.getBounds());
    }

    public LinearTransform1d getManTransform() {
        return this.transform;
    }

    public Man.Direction getDirection() {
        if (this.currentImage == this.leftMan) {
            return Man.Direction.LEFT;
        }
        if (this.currentImage == this.rightMan) {
            return Man.Direction.RIGHT;
        }
        return Man.Direction.STILL;
    }

    public void setDirection(double d) {
        this.setVelocity(d);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.module.isRecordMode() || this.module.isPaused() || !this.module.isSmoothingSmooth()) {
            this.module.setRecordMode();
            this.module.setSmoothingSmooth();
            this.module.setPaused(false);
        }
        Point point = this.dragHandler.getNewLocation(mouseEvent.getPoint());
        int n = point.x;
        double d = this.inversion.transform(n);
        this.m.setPosition(d);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void setY(int n) {
        this.y = n;
        this.setBoundsDirty();
        this.autorepaint();
    }

    public Rectangle getRectangle() {
        return new Rectangle(this.x - this.currentImage.getWidth() / 2, this.y, this.currentImage.getWidth(), this.currentImage.getHeight());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.m.setGrabbed(false);
        this.dragHandler = null;
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.mouseReleased();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    public void mouseExited(MouseEvent mouseEvent) {
        mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void setTransform(LinearTransform1d linearTransform1d) {
        this.transform = linearTransform1d;
        this.inversion = linearTransform1d.getInvertedInstance();
        this.positionChanged();
    }

    public boolean contains(int n, int n2) {
        return this.getRectangle().contains(n, n2);
    }

    protected Rectangle determineBounds() {
        return this.getRectangle();
    }

    class DragHandler {
        private Point dragStartPt;
        private Point viewStart;
        private Point newLocation = new Point();

        public DragHandler(Point point, Point point2) {
            this.dragStartPt = point;
            this.viewStart = point2;
        }

        public Point getNewLocation(Point point) {
            int n = point.x - this.dragStartPt.x;
            int n2 = point.y - this.dragStartPt.y;
            this.newLocation.x = n + this.viewStart.x;
            this.newLocation.y = n2 + this.viewStart.y;
            return this.newLocation;
        }
    }

    public static interface Listener {
        public void manGraphicChanged();

        public void mouseReleased();
    }
}

