/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.view;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_movingman.math.ImmutableVector2D;
import edu.colorado.phet.common_movingman.model.CompositeModelElement;
import edu.colorado.phet.common_movingman.model.clock.ClockTickEvent;
import edu.colorado.phet.common_movingman.model.clock.ClockTickListener;
import edu.colorado.phet.common_movingman.view.ApparatusPanel2;
import edu.colorado.phet.common_movingman.view.BasicGraphicsSetup;
import edu.colorado.phet.common_movingman.view.GraphicsSetup;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.RepaintDebugGraphic;
import edu.colorado.phet.movingman.MMKeySuite;
import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.common.LinearTransform1d;
import edu.colorado.phet.movingman.common.WiggleMe;
import edu.colorado.phet.movingman.model.TimeListenerAdapter;
import edu.colorado.phet.movingman.plots.MMPlotSuite;
import edu.colorado.phet.movingman.plots.PlotSet;
import edu.colorado.phet.movingman.view.ArrowSetGraphic;
import edu.colorado.phet.movingman.view.GoPauseClearPanel;
import edu.colorado.phet.movingman.view.ManGraphic;
import edu.colorado.phet.movingman.view.MovingManLayout;
import edu.colorado.phet.movingman.view.PlotBorderGraphic;
import edu.colorado.phet.movingman.view.SliderWiggleMe;
import edu.colorado.phet.movingman.view.TimeGraphic;
import edu.colorado.phet.movingman.view.WalkWayGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.event.MouseInputAdapter;

public class MovingManApparatusPanel
extends ApparatusPanel2 {
    private MovingManModule module;
    private LinearTransform1d manPositionTransform;
    private MMKeySuite keySuite;
    private boolean inited;
    private MovingManLayout movingManLayout;
    private ManGraphic.Listener wiggleMeListener;
    private PlotSet plotSet;
    private ManGraphic manGraphic;
    private TimeGraphic timerGraphic;
    private WalkWayGraphic walkwayGraphic;
    private Color backgroundColor;
    private WiggleMe wiggleMe;
    private PhetImageGraphic bufferedWalkwayGraphic;
    private PlotBorderGraphic xBorder;
    private PlotBorderGraphic vBorder;
    private PlotBorderGraphic aBorder;
    private ArrowSetGraphic arrowSetGraphic;

    public MovingManApparatusPanel(MovingManModule movingManModule) throws IOException {
        super(movingManModule.getClock());
        this.removePanelResizeHandler();
        movingManModule.getClock().addClockTickListener(new ClockTickListener(){

            public void clockTicked(ClockTickEvent clockTickEvent) {
                MovingManApparatusPanel.this.handleUserInput();
                MovingManApparatusPanel.this.updateGraphics(clockTickEvent);
                MovingManApparatusPanel.this.paint();
            }
        });
        this.module = movingManModule;
        this.keySuite = new MMKeySuite(movingManModule);
        this.addKeyListener(this.keySuite);
        this.addGraphicsSetup(new BasicGraphicsSetup());
        this.manPositionTransform = new LinearTransform1d(-movingManModule.getMaxManPosition(), movingManModule.getMaxManPosition(), 50.0, 600.0);
        this.backgroundColor = new Color(250, 190, 240);
        this.manGraphic = new ManGraphic(movingManModule, this, movingManModule.getMan(), 0, this.manPositionTransform);
        this.addGraphic(this.manGraphic, 11.0);
        this.timerGraphic = new TimeGraphic(movingManModule, this, movingManModule.getTimeModel().getRecordTimer(), movingManModule.getTimeModel().getPlaybackTimer(), 80, 40);
        this.addGraphic(this.timerGraphic, 11.0);
        this.walkwayGraphic = new WalkWayGraphic(movingManModule, this, 11);
        this.bufferedWalkwayGraphic = MovingManApparatusPanel.createBuffer(this.walkwayGraphic, new BasicGraphicsSetup(), 1, this.walkwayGraphic.getBackgroundColor());
        this.addGraphic(this.bufferedWalkwayGraphic, 10.0);
        Point2D point2D = this.manGraphic.getRectangle().getLocation();
        point2D = new Point2D.Double(((Point2D)point2D).getX() + 50.0, ((Point2D)point2D).getY() + 50.0);
        this.wiggleMe = new WiggleMe(this, point2D, new ImmutableVector2D.Double(0.0, 1.0), 15.0, 0.02, SimStrings.get("help.drag-the-man"));
        this.wiggleMe.setVisible(false);
        movingManModule.addListener(new TimeListenerAdapter(){

            public void recordingStarted() {
                MovingManApparatusPanel.this.setWiggleMeVisible(false);
            }
        });
        this.wiggleMeListener = new ManGraphic.Listener(){

            public void manGraphicChanged() {
                Point2D point2D = MovingManApparatusPanel.this.manGraphic.getRectangle().getLocation();
                point2D = new Point2D.Double(point2D.getX() - (double)MovingManApparatusPanel.this.wiggleMe.getWidth() - 20.0, point2D.getY() + MovingManApparatusPanel.this.manGraphic.getRectangle().getHeight() / 2.0);
                MovingManApparatusPanel.this.wiggleMe.setCenter(new Point((int)point2D.getX(), (int)point2D.getY()));
            }

            public void mouseReleased() {
            }
        };
        this.setWiggleMeVisible(true);
        this.manGraphic.addListener(this.wiggleMeListener);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                MovingManApparatusPanel.this.requestFocus();
            }
        });
        this.plotSet = new PlotSet(movingManModule, this);
        this.xBorder = new PlotBorderGraphic(this, this.plotSet.getPositionPlotSuite());
        this.vBorder = new PlotBorderGraphic(this, this.plotSet.getVelocityPlotSuite());
        this.aBorder = new PlotBorderGraphic(this, this.plotSet.getAccelerationPlotSuite());
        this.plotSet.addListener(new PlotSet.Listener(){

            public void setAccelerationControlMode() {
                MovingManApparatusPanel.this.highlightPlots(false, false, true);
            }

            public void setVelocityControlMode() {
                MovingManApparatusPanel.this.highlightPlots(false, true, false);
            }

            public void setPositionControlMode() {
                MovingManApparatusPanel.this.highlightPlots(true, false, false);
            }
        });
        this.manGraphic.addMouseInputListener(new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                MovingManApparatusPanel.this.highlightPlots(false, false, false);
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                MovingManApparatusPanel.this.highlightPlots(false, false, false);
            }
        });
        this.addGraphic(this.plotSet.getPositionPlotSuite(), 3.0);
        this.addGraphic(this.plotSet.getVelocityPlotSuite(), 4.0);
        this.addGraphic(this.plotSet.getAccelerationPlotSuite(), 5.0);
        this.movingManLayout = new MovingManLayout(this);
        RepaintDebugGraphic.enable(this, movingManModule.getClock());
        this.setDoubleBuffered(true);
        SliderWiggleMe sliderWiggleMe = new SliderWiggleMe(this, movingManModule, movingManModule.getClock());
        this.addGraphic(sliderWiggleMe, Double.POSITIVE_INFINITY);
        this.arrowSetGraphic = new ArrowSetGraphic(movingManModule, this, this.getManGraphic());
        this.addGraphic(this.arrowSetGraphic, Double.POSITIVE_INFINITY);
    }

    private void updateGraphics(ClockTickEvent clockTickEvent) {
        this.arrowSetGraphic.updateGraphics();
    }

    private void highlightPlots(boolean bl, boolean bl2, boolean bl3) {
        this.getPlotSet().getPositionPlot().setSelected(bl);
        this.getPlotSet().getVelocityPlot().setSelected(bl2);
        this.getPlotSet().getAccelerationPlot().setSelected(bl3);
    }

    public static PhetImageGraphic createBuffer(PhetGraphic phetGraphic, GraphicsSetup graphicsSetup, int n, Paint paint) {
        PhetImageGraphic phetImageGraphic = new PhetImageGraphic(phetGraphic.getComponent());
        Rectangle rectangle = phetGraphic.getBounds();
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphicsSetup.setup(graphics2D);
        graphics2D.setPaint(paint);
        graphics2D.translate(-rectangle.x, -rectangle.y);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        phetGraphic.paint(graphics2D);
        graphics2D.setStroke(new BasicStroke(4.0f));
        graphics2D.setColor(Color.black);
        graphics2D.draw(rectangle);
        phetImageGraphic.setImage(bufferedImage);
        return phetImageGraphic;
    }

    public void paint(Graphics graphics) {
        if (this.inited) {
            super.paint(graphics);
        }
    }

    public void paintImmediately(int n, int n2, int n3, int n4) {
        if (this.inited) {
            super.paintImmediately(n, n2, n3, n4);
        }
    }

    public Component add(Component component) {
        KeyListener[] keyListenerArray = component.getKeyListeners();
        if (!Arrays.asList(keyListenerArray).contains(this.getKeySuite())) {
            component.addKeyListener(this.getKeySuite());
        }
        return super.add(component);
    }

    private KeyListener getKeySuite() {
        return this.keySuite;
    }

    public void setInited(boolean bl) {
        this.inited = bl;
    }

    public void relayout() {
        this.movingManLayout.relayout();
    }

    public void setManTransform(LinearTransform1d linearTransform1d) {
        this.manPositionTransform = linearTransform1d;
        this.manGraphic.setTransform(linearTransform1d);
        this.walkwayGraphic.setTransform(linearTransform1d);
        this.repaintBackground();
    }

    public WalkWayGraphic getWalkwayGraphic() {
        return this.walkwayGraphic;
    }

    public void setWiggleMeVisible(boolean bl) {
        if (bl == this.wiggleMe.isVisible()) {
            return;
        }
        if (!bl) {
            this.wiggleMe.setVisible(false);
            this.removeGraphic(this.wiggleMe);
            this.getModel().removeModelElement(this.wiggleMe);
            this.manGraphic.removeListener(this.wiggleMeListener);
        } else {
            this.wiggleMe.setVisible(true);
            this.addGraphic(this.wiggleMe, 100.0);
            this.getModel().addModelElement(this.wiggleMe);
            this.manGraphic.addListener(this.wiggleMeListener);
        }
    }

    private CompositeModelElement getModel() {
        return this.module.getModel();
    }

    public void repaintBackground() {
        PhetImageGraphic phetImageGraphic = MovingManApparatusPanel.createBuffer(this.walkwayGraphic, new BasicGraphicsSetup(), 1, this.walkwayGraphic.getBackgroundColor());
        this.bufferedWalkwayGraphic.setImage(phetImageGraphic.getImage());
        this.bufferedWalkwayGraphic.setRegistrationPoint(-this.walkwayGraphic.getBounds().x, -this.walkwayGraphic.getBounds().y);
        if (this.movingManLayout != null) {
            this.bufferedWalkwayGraphic.setLocation(0, 0);
        }
        this.repaint();
    }

    public ManGraphic getManGraphic() {
        return this.manGraphic;
    }

    public PlotSet getPlotSet() {
        return this.plotSet;
    }

    public LinearTransform1d getManPositionTransform() {
        return this.manPositionTransform;
    }

    public MovingManModule getModule() {
        return this.module;
    }

    public void reset() {
        this.setCursorsVisible(false);
        this.getPlotSet().reset();
        this.repaint();
    }

    public void setCursorsVisible(boolean bl) {
        this.getPlotSet().setCursorsVisible(bl);
    }

    public void initialize() {
        this.repaintBackground();
    }

    public void setShowVelocityVector(boolean bl) {
        this.arrowSetGraphic.setShowVelocityVector(bl);
    }

    public void setShowAccelerationVector(boolean bl) {
        this.arrowSetGraphic.setShowAccelerationVector(bl);
    }

    public void setBoundaryConditionsClosed() {
        this.walkwayGraphic.setBoundaryConditionsClosed();
        this.repaintBackground();
        this.movingManLayout.relayout();
    }

    public void setBoundaryConditionsOpen() {
        this.walkwayGraphic.setBoundaryConditionsOpen();
        this.repaintBackground();
        this.movingManLayout.relayout();
    }

    public void requestEditInTextBox(GoPauseClearPanel goPauseClearPanel) {
        MMPlotSuite mMPlotSuite = this.plotSet.getPlotSuiteFor(goPauseClearPanel);
        MMPlotSuite[] mMPlotSuiteArray = this.plotSet.getOtherPlots(mMPlotSuite);
        for (int i = 0; i < mMPlotSuiteArray.length; ++i) {
            MMPlotSuite mMPlotSuite2 = mMPlotSuiteArray[i];
            mMPlotSuite2.getTextBox().deselectAll();
        }
        mMPlotSuite.getTextBox().selectAll();
        mMPlotSuite.getTextBoxGraphic().repaint();
        mMPlotSuite.getTextBox().getTextField().requestFocus();
        mMPlotSuite.getTextBoxGraphic().repaint();
    }

    public void minimizeGraphsExceptPosition() {
        this.plotSet.getVelocityPlotSuite().setPlotVisible(false);
        this.plotSet.getAccelerationPlotSuite().setPlotVisible(false);
    }
}

