/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.view;

import edu.colorado.phet.movingman.MMUtil;
import edu.colorado.phet.movingman.common.LinearTransform1d;
import edu.colorado.phet.movingman.view.MovingManApparatusPanel;
import java.awt.Component;
import java.util.ArrayList;

public class MovingManLayout {
    private int walkwayHeight = 150;
    private int topInset = 20;
    private int walkwayBottomInset = 0;
    private int spaceBetweenPlots = MMUtil.isHighScreenResolution() ? 10 : 10;
    private MMVerticalLayout verticalLayout;
    private MovingManApparatusPanel movingManApparatusPanel;
    private LayoutItem layoutItemX;
    private LayoutItem layoutItemV;
    private LayoutItem layoutItemA;
    private int walkwayInsetX = 55;

    public MovingManLayout(MovingManApparatusPanel movingManApparatusPanel) {
        this.movingManApparatusPanel = movingManApparatusPanel;
        this.verticalLayout = new MMVerticalLayout(this.movingManApparatusPanel);
        this.verticalLayout.addSpacer(this.walkwayHeight);
        this.verticalLayout.addSpacer(this.walkwayBottomInset);
        this.verticalLayout.addSpacer(this.topInset);
        this.verticalLayout.addSpacer(this.spaceBetweenPlots);
        this.layoutItemX = movingManApparatusPanel.getPlotSet().getPositionPlotSuite();
        this.verticalLayout.addLayoutItem(this.layoutItemX);
        this.verticalLayout.addSpacer(this.spaceBetweenPlots);
        this.layoutItemV = movingManApparatusPanel.getPlotSet().getVelocityPlotSuite();
        this.verticalLayout.addLayoutItem(this.layoutItemV);
        this.verticalLayout.addSpacer(this.spaceBetweenPlots);
        this.layoutItemA = movingManApparatusPanel.getPlotSet().getAccelerationPlotSuite();
        this.verticalLayout.addLayoutItem(this.layoutItemA);
        this.verticalLayout.addSpacer(this.spaceBetweenPlots);
        this.relayout();
    }

    public void relayout() {
        this.verticalLayout.layout();
        LinearTransform1d linearTransform1d = this.movingManApparatusPanel.getManPositionTransform();
        LinearTransform1d linearTransform1d2 = new LinearTransform1d(linearTransform1d.getMinInput(), linearTransform1d.getMaxInput(), this.walkwayInsetX, this.movingManApparatusPanel.getWidth() - this.walkwayInsetX);
        this.movingManApparatusPanel.setManTransform(linearTransform1d2);
        this.movingManApparatusPanel.getManGraphic().setY(this.walkwayHeight - this.movingManApparatusPanel.getManGraphic().getHeight());
        double d = linearTransform1d2.getMaxOutput() - linearTransform1d2.getMinOutput();
        this.movingManApparatusPanel.getWalkwayGraphic().setSize((int)d + 200, this.walkwayHeight);
        this.movingManApparatusPanel.repaintBackground();
    }

    static class Spacer
    implements LayoutItem {
        private int height;

        public Spacer(int n) {
            this.height = n;
        }

        public boolean isVariable() {
            return false;
        }

        public int getLayoutHeight() {
            return this.height;
        }

        public void setVerticalParameters(int n, int n2) {
        }

        public void setY(int n) {
        }
    }

    public static interface LayoutItem {
        public boolean isVariable();

        public int getLayoutHeight();

        public void setVerticalParameters(int var1, int var2);

        public void setY(int var1);
    }

    static class MMVerticalLayout {
        ArrayList layoutItems = new ArrayList();
        Component component;

        public MMVerticalLayout(Component component) {
            this.component = component;
        }

        public void addLayoutItem(LayoutItem layoutItem) {
            this.layoutItems.add(layoutItem);
        }

        public int getConstantHeight() {
            int n = 0;
            for (int i = 0; i < this.layoutItems.size(); ++i) {
                LayoutItem layoutItem = (LayoutItem)this.layoutItems.get(i);
                if (layoutItem.isVariable()) continue;
                n += layoutItem.getLayoutHeight();
            }
            return n;
        }

        public void layout() {
            int n = this.getConstantHeight();
            int n2 = this.numVariableItems();
            int n3 = this.component.getHeight() - n;
            int n4 = 0;
            if (n2 > 0) {
                n4 = n3 / n2;
            }
            int n5 = 0;
            for (int i = 0; i < this.layoutItems.size(); ++i) {
                LayoutItem layoutItem = (LayoutItem)this.layoutItems.get(i);
                if (layoutItem.isVariable()) {
                    layoutItem.setVerticalParameters(n5, n4);
                    n5 += n4;
                    continue;
                }
                layoutItem.setY(n5);
                n5 += layoutItem.getLayoutHeight();
            }
        }

        private int numVariableItems() {
            int n = 0;
            for (int i = 0; i < this.layoutItems.size(); ++i) {
                LayoutItem layoutItem = (LayoutItem)this.layoutItems.get(i);
                if (!layoutItem.isVariable()) continue;
                ++n;
            }
            return n;
        }

        public void addSpacer(int n) {
            this.addLayoutItem(new Spacer(n));
        }
    }
}

