/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.view;

import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_movingman.view.ApparatusPanel;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_movingman.view.util.GraphicsState;
import edu.colorado.phet.movingman.MMFontManager;
import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.model.MMTimer;
import edu.colorado.phet.movingman.view.MovingManApparatusPanel;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;

public class TimeGraphic
extends PhetGraphic {
    private String timeStr;
    private MovingManModule module;
    private int x;
    private int y;
    private Font f = MMFontManager.getFontSet().getTimeFont();
    private DefaultDecimalFormat decimalFormat = new DefaultDecimalFormat("#0.00");
    private FontRenderContext frc;
    private ApparatusPanel apparatusPanel;

    public TimeGraphic(MovingManModule movingManModule, MovingManApparatusPanel movingManApparatusPanel, final MMTimer mMTimer, final MMTimer mMTimer2, int n, int n2) {
        super(movingManApparatusPanel);
        this.apparatusPanel = movingManApparatusPanel;
        this.module = movingManModule;
        this.x = n;
        this.y = n2;
        MMTimer.Listener listener = new MMTimer.Listener(){

            public void timeChanged() {
                TimeGraphic.this.update(mMTimer);
            }
        };
        MMTimer.Listener listener2 = new MMTimer.Listener(){

            public void timeChanged() {
                TimeGraphic.this.update(mMTimer2);
            }
        };
        mMTimer.addListener(listener);
        mMTimer2.addListener(listener2);
        this.update(mMTimer);
    }

    public void paint(Graphics2D graphics2D) {
        GraphicsState graphicsState = new GraphicsState(graphics2D);
        this.frc = graphics2D.getFontRenderContext();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setFont(this.f);
        graphics2D.drawString(this.timeStr, this.x, this.y);
        graphicsState.restoreGraphics();
    }

    public void update(MMTimer mMTimer) {
        double d;
        double d2 = d = mMTimer.getTime();
        Rectangle rectangle = this.getShape();
        this.timeStr = this.decimalFormat.format(d2) + " " + SimStrings.get("units.seconds");
        this.repaint(rectangle, this.getShape());
    }

    private void repaint(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null || rectangle2 == null) {
            return;
        }
        Rectangle rectangle3 = rectangle2.union(rectangle);
        this.apparatusPanel.repaint(rectangle3);
    }

    public Rectangle getShape() {
        if (this.frc == null) {
            return null;
        }
        Rectangle2D rectangle2D = this.f.getStringBounds(this.timeStr, this.frc);
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        double_.height = Math.max(50.0, double_.height);
        double_.x = this.x;
        double_.y = (double)this.y - double_.height;
        return new Rectangle((int)double_.x, (int)double_.y, (int)double_.width, (int)double_.height);
    }

    protected Rectangle determineBounds() {
        return this.getShape();
    }
}

