/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.view;

import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_movingman.math.Function$LinearFunction;
import edu.colorado.phet.common_movingman.view.ApparatusPanel;
import edu.colorado.phet.common_movingman.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.common_movingman.view.util.BufferedImageUtils;
import edu.colorado.phet.common_movingman.view.util.ImageLoader;
import edu.colorado.phet.movingman.MMFontManager;
import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.common.LinearTransform1d;
import edu.colorado.phet.movingman.view.LeftEdgeWalkwayObjectGraphic;
import edu.colorado.phet.movingman.view.RightEdgeWalkwayObjectGraphic;
import edu.colorado.phet.movingman.view.WalkwayObjectGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;

public class WalkWayGraphic
extends CompositePhetGraphic {
    private WalkwayObjectGraphic treeObject;
    private WalkwayObjectGraphic houseObject;
    private WalkwayObjectGraphic leftWall;
    private WalkwayObjectGraphic rightWall;
    private Function$LinearFunction transform;
    private PhetShapeGraphic backgroundGraphic;
    private PhetShapeGraphic floorGraphic;
    private TickSetGraphic tickSetGraphic;
    private int floorHeight = 6;
    private Dimension size;
    private Paint backgroundColor = Color.yellow;
    private BufferedImage barrierImage;
    private boolean boundaryConditionsClosed = true;

    public WalkWayGraphic(MovingManModule movingManModule, ApparatusPanel apparatusPanel, int n) throws IOException {
        this(apparatusPanel, movingManModule, n, -8.0, 8.0, new Function$LinearFunction(-10.0, 10.0, 0.0, 500.0));
    }

    public WalkWayGraphic(ApparatusPanel apparatusPanel, MovingManModule movingManModule, int n, double d, double d2, Function$LinearFunction function$LinearFunction) throws IOException {
        super(apparatusPanel);
        this.transform = function$LinearFunction;
        this.treeObject = new WalkwayObjectGraphic(this, d, "moving-man/images/tree.gif");
        this.houseObject = new WalkwayObjectGraphic(this, d2, "moving-man/images/cottage.gif");
        this.backgroundGraphic = new PhetShapeGraphic(apparatusPanel, null, Color.white, new BasicStroke(1.0f), Color.black);
        this.floorGraphic = new PhetShapeGraphic(apparatusPanel, null, Color.white);
        this.tickSetGraphic = new TickSetGraphic(apparatusPanel, function$LinearFunction);
        BufferedImage bufferedImage = ImageLoader.loadBufferedImage("moving-man/images/barrier.jpg");
        this.barrierImage = BufferedImageUtils.rescaleYMaintainAspectRatio(apparatusPanel, bufferedImage, 130);
        this.setWalls();
        this.addGraphic(this.backgroundGraphic);
        this.addGraphic(this.floorGraphic);
        this.addGraphic(this.treeObject);
        this.addGraphic(this.houseObject);
        this.addGraphic(this.tickSetGraphic);
        this.setSize(900, 150);
        this.setWalls();
        this.update();
    }

    private void setWalls() {
        this.removeWalls();
        if (this.boundaryConditionsClosed) {
            double d = -1.0;
            if (this.transform.getMinInput() < this.transform.getMaxInput()) {
                d = 1.0;
            }
            this.rightWall = new LeftEdgeWalkwayObjectGraphic(this, d * 10.0, this.barrierImage);
            this.leftWall = new RightEdgeWalkwayObjectGraphic(this, -d * 10.0, this.barrierImage);
            this.addGraphic(this.leftWall);
            this.addGraphic(this.rightWall);
        }
    }

    public void setLocation(Point point) {
        super.setLocation(point);
    }

    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
    }

    public int getFloorY() {
        return this.size.height - this.floorHeight;
    }

    public void setSize(int n, int n2) {
        this.size = new Dimension(n, n2);
        this.update();
    }

    public int getViewCoordinate(double d) {
        return (int)this.transform.evaluate(d);
    }

    public Paint getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setTransform(LinearTransform1d linearTransform1d) {
        this.transform = linearTransform1d;
        this.tickSetGraphic.setTransform(linearTransform1d);
        this.setWalls();
        this.update();
    }

    public void setBoundaryConditionsClosed() {
        this.setWalls();
        this.boundaryConditionsClosed = true;
    }

    public void setBoundaryConditionsOpen() {
        this.removeWalls();
        this.boundaryConditionsClosed = false;
    }

    private void removeWalls() {
        this.removeGraphic(this.leftWall);
        this.removeGraphic(this.rightWall);
    }

    private void update() {
        Rectangle rectangle = this.getSkyRect();
        this.backgroundGraphic.setShape(rectangle);
        Color color = new Color(150, 120, 255);
        this.backgroundGraphic.setPaint(new GradientPaint(rectangle.x, rectangle.y, color, rectangle.x, rectangle.y + rectangle.height, Color.white));
        Color color2 = new Color(100, 100, 255);
        Rectangle rectangle2 = this.getFloor();
        this.floorGraphic.setPaint(new GradientPaint(rectangle2.x, rectangle2.y, color2, rectangle2.x, rectangle2.y + rectangle2.height, Color.white));
        this.floorGraphic.setShape(rectangle2);
        this.tickSetGraphic.setY(rectangle2.y);
        this.tickSetGraphic.update();
        this.treeObject.update();
        this.houseObject.update();
        this.leftWall.update();
        this.rightWall.update();
        this.setBoundsDirty();
        this.repaint();
    }

    private Rectangle getFloor() {
        int n = this.size.height - this.floorHeight;
        return new Rectangle(0, n, this.size.width, this.size.height - n);
    }

    private Rectangle getSkyRect() {
        return new Rectangle(0, 0, this.size.width, this.size.height);
    }

    public static class TickGraphic
    extends CompositePhetGraphic {
        private double modelx;
        private Function$LinearFunction transform;
        private String text;
        private int y = 134;
        private PhetShapeGraphic shapeGraphic;
        private Font font = MMFontManager.getFontSet().getWalkwayFont();
        private PhetTextGraphic textGraphic;

        public TickGraphic(Component component, double d, Function$LinearFunction function$LinearFunction, String string) {
            super(component);
            this.modelx = d;
            this.transform = function$LinearFunction;
            this.text = string;
            this.shapeGraphic = new PhetShapeGraphic(component, null, new BasicStroke(1.0f), Color.black);
            this.addGraphic(this.shapeGraphic);
            this.textGraphic = new PhetTextGraphic(component, this.font, string, Color.black, 0, 0);
            this.addGraphic(this.textGraphic);
        }

        public void update() {
            int n = (int)this.transform.evaluate(this.modelx);
            int n2 = 5;
            Line2D.Double double_ = new Line2D.Double(n, this.y, n, this.y + n2);
            this.shapeGraphic.setShape(double_);
            this.textGraphic.setLocation(n - this.textGraphic.getWidth() / 2, this.y + n2);
        }

        public void setY(int n) {
            this.y = n;
        }

        public void setTransform(LinearTransform1d linearTransform1d) {
            this.transform = linearTransform1d;
        }
    }

    public static class TickSetGraphic
    extends CompositePhetGraphic {
        private int numTickMarks = 11;
        private DefaultDecimalFormat format = new DefaultDecimalFormat("##");
        ArrayList graphicList = new ArrayList();

        public TickSetGraphic(Component component, Function$LinearFunction function$LinearFunction) {
            super(component);
            double d = -10.0;
            double d2 = -d;
            double d3 = d2 - d;
            double d4 = d3 / (double)(this.numTickMarks - 1);
            for (int i = 0; i < this.numTickMarks; ++i) {
                double d5 = d + (double)i * d4;
                String string = this.format.format(d5);
                if (string.equals("0")) {
                    string = "0 " + SimStrings.get("units.meters");
                }
                TickGraphic tickGraphic = new TickGraphic(component, d5, function$LinearFunction, string);
                this.graphicList.add(tickGraphic);
                this.addGraphic(tickGraphic);
            }
        }

        public void update() {
            for (int i = 0; i < this.graphicList.size(); ++i) {
                TickGraphic tickGraphic = (TickGraphic)this.graphicList.get(i);
                tickGraphic.update();
            }
        }

        public void setY(int n) {
            for (int i = 0; i < this.graphicList.size(); ++i) {
                TickGraphic tickGraphic = (TickGraphic)this.graphicList.get(i);
                tickGraphic.setY(n);
            }
        }

        public void setTransform(LinearTransform1d linearTransform1d) {
            for (int i = 0; i < this.graphicList.size(); ++i) {
                TickGraphic tickGraphic = (TickGraphic)this.graphicList.get(i);
                tickGraphic.setTransform(linearTransform1d);
            }
        }
    }
}

