/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.view;

import edu.colorado.phet.common_movingman.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common_movingman.view.util.ImageLoader;
import edu.colorado.phet.movingman.view.WalkWayGraphic;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class WalkwayObjectGraphic
extends GraphicLayerSet {
    private WalkWayGraphic walkWayGraphic;
    private double modelLocation;

    public WalkwayObjectGraphic(WalkWayGraphic walkWayGraphic, double d, String string) {
        this(walkWayGraphic, d, WalkwayObjectGraphic.loadImage(string));
    }

    private static BufferedImage loadImage(String string) {
        try {
            return ImageLoader.loadBufferedImage(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }

    public WalkwayObjectGraphic(WalkWayGraphic walkWayGraphic, double d, BufferedImage bufferedImage) {
        super(walkWayGraphic.getComponent());
        this.walkWayGraphic = walkWayGraphic;
        this.modelLocation = d;
        PhetImageGraphic phetImageGraphic = new PhetImageGraphic(this.getComponent(), bufferedImage);
        this.addGraphic(phetImageGraphic);
    }

    public void update() {
        int n = this.walkWayGraphic.getViewCoordinate(this.modelLocation);
        int n2 = this.walkWayGraphic.getFloorY() - this.getHeight();
        this.setLocation(n - this.getWidth() / 2, n2);
    }

    protected WalkWayGraphic getWalkWayGraphic() {
        return this.walkWayGraphic;
    }

    public double getModelLocation() {
        return this.modelLocation;
    }
}

