/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PNodeFilter;
import edu.umd.cs.piccolo.util.PObjectOutputStream;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;

public class PNode
implements Cloneable,
Serializable,
Printable {
    private static final PBounds TEMP_REPAINT_BOUNDS = new PBounds();
    public static PSceneGraphDelegate SCENE_GRAPH_DELEGATE = null;
    private transient PNode parent;
    private List children;
    private PBounds bounds = new PBounds();
    private PAffineTransform transform;
    private Paint paint;
    private float transparency = 1.0f;
    private PBounds fullBoundsCache = new PBounds();
    private int propertyChangeParentMask = 0;
    private transient SwingPropertyChangeSupport changeSupport;
    private transient EventListenerList listenerList;
    private boolean pickable = true;
    private boolean childrenPickable = true;
    private boolean visible = true;
    private boolean childBoundsVolatile;
    private boolean paintInvalid;
    private boolean childPaintInvalid;
    private boolean boundsChanged;
    private boolean fullBoundsInvalid;
    private boolean childBoundsInvalid;
    private boolean occluded;

    public Object clone() {
        try {
            byte[] byArray = PObjectOutputStream.toByteArray(this);
            return (PNode)new ObjectInputStream(new ByteArrayInputStream(byArray)).readObject();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return null;
    }

    public Point2D localToParent(Point2D point2D) {
        if (this.transform == null) {
            return point2D;
        }
        return this.transform.transform(point2D, point2D);
    }

    public Rectangle2D localToParent(Rectangle2D rectangle2D) {
        if (this.transform == null) {
            return rectangle2D;
        }
        return this.transform.transform(rectangle2D, rectangle2D);
    }

    public Point2D parentToLocal(Point2D point2D) {
        if (this.transform == null) {
            return point2D;
        }
        try {
            return this.transform.inverseTransform(point2D, point2D);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
            return null;
        }
    }

    public Rectangle2D parentToLocal(Rectangle2D rectangle2D) {
        if (this.transform == null) {
            return rectangle2D;
        }
        return this.transform.inverseTransform(rectangle2D, rectangle2D);
    }

    public Point2D localToGlobal(Point2D point2D) {
        PNode pNode = this;
        while (pNode != null) {
            point2D = pNode.localToParent(point2D);
            pNode = pNode.parent;
        }
        return point2D;
    }

    public Rectangle2D localToGlobal(Rectangle2D rectangle2D) {
        PNode pNode = this;
        while (pNode != null) {
            rectangle2D = pNode.localToParent(rectangle2D);
            pNode = pNode.parent;
        }
        return rectangle2D;
    }

    public Point2D globalToLocal(Point2D point2D) {
        if (this.parent != null) {
            point2D = this.parent.globalToLocal(point2D);
        }
        return this.parentToLocal(point2D);
    }

    public Rectangle2D globalToLocal(Rectangle2D rectangle2D) {
        if (this.parent != null) {
            rectangle2D = this.parent.globalToLocal(rectangle2D);
        }
        return this.parentToLocal(rectangle2D);
    }

    public EventListenerList getListenerList() {
        return this.listenerList;
    }

    public void addInputEventListener(PInputEventListener pInputEventListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.getListenerList().add(PInputEventListener.class, pInputEventListener);
    }

    public void removeInputEventListener(PInputEventListener pInputEventListener) {
        if (this.listenerList == null) {
            return;
        }
        this.getListenerList().remove(PInputEventListener.class, pInputEventListener);
        if (this.listenerList.getListenerCount() == 0) {
            this.listenerList = null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    protected void firePropertyChange(int n, String string, Object object, Object object2) {
        PropertyChangeEvent propertyChangeEvent = null;
        if (this.changeSupport != null) {
            propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            this.changeSupport.firePropertyChange(propertyChangeEvent);
        }
        if (this.parent != null && (n & this.propertyChangeParentMask) != 0) {
            if (propertyChangeEvent == null) {
                propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            }
            this.parent.fireChildPropertyChange(propertyChangeEvent, n);
        }
    }

    protected void fireChildPropertyChange(PropertyChangeEvent propertyChangeEvent, int n) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyChangeEvent);
        }
        if (this.parent != null && (n & this.propertyChangeParentMask) != 0) {
            this.parent.fireChildPropertyChange(propertyChangeEvent, n);
        }
    }

    public PBounds getBounds() {
        return (PBounds)this.getBoundsReference().clone();
    }

    public PBounds getBoundsReference() {
        return this.bounds;
    }

    public boolean setBounds(Rectangle2D rectangle2D) {
        return this.setBounds(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean setBounds(double d, double d2, double d3, double d4) {
        if (this.bounds.x != d || this.bounds.y != d2 || this.bounds.width != d3 || this.bounds.height != d4) {
            this.bounds.setRect(d, d2, d3, d4);
            if (d3 <= 0.0 || d4 <= 0.0) {
                this.bounds.reset();
            }
            this.internalUpdateBounds(d, d2, d3, d4);
            this.invalidatePaint();
            this.signalBoundsChanged();
            return true;
        }
        return false;
    }

    protected void internalUpdateBounds(double d, double d2, double d3, double d4) {
    }

    public void resetBounds() {
        this.setBounds(0.0, 0.0, 0.0, 0.0);
    }

    public double getX() {
        return this.getBoundsReference().getX();
    }

    public double getY() {
        return this.getBoundsReference().getY();
    }

    public double getWidth() {
        return this.getBoundsReference().getWidth();
    }

    public double getHeight() {
        return this.getBoundsReference().getHeight();
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return true;
        }
        return this.getBoundsReference().intersects(rectangle2D);
    }

    public PBounds getFullBounds() {
        return (PBounds)this.getFullBoundsReference().clone();
    }

    public PBounds getFullBoundsReference() {
        this.validateFullBounds();
        return this.fullBoundsCache;
    }

    public PBounds computeFullBounds(PBounds pBounds) {
        PBounds pBounds2 = this.getUnionOfChildrenBounds(pBounds);
        pBounds2.add(this.getBoundsReference());
        this.localToParent(pBounds2);
        return pBounds2;
    }

    public PBounds getUnionOfChildrenBounds(PBounds pBounds) {
        if (pBounds == null) {
            pBounds = new PBounds();
        } else {
            pBounds.resetToZero();
        }
        int n = this.getChildrenCount();
        for (int i = 0; i < n; ++i) {
            PNode pNode = (PNode)this.children.get(i);
            pBounds.add(pNode.getFullBoundsReference());
        }
        return pBounds;
    }

    public boolean fullIntersects(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return true;
        }
        return this.getFullBoundsReference().intersects(rectangle2D);
    }

    protected boolean getBoundsVolatile() {
        return false;
    }

    protected void setBoundsChanged(boolean bl) {
        this.boundsChanged = bl;
    }

    protected boolean getFullBoundsInvalid() {
        return this.fullBoundsInvalid;
    }

    protected void setFullBoundsInvalid(boolean bl) {
        this.fullBoundsInvalid = bl;
    }

    protected boolean getChildBoundsInvalid() {
        return this.childBoundsInvalid;
    }

    protected void setChildBoundsInvalid(boolean bl) {
        this.childBoundsInvalid = bl;
    }

    public void signalBoundsChanged() {
        this.invalidateFullBounds();
        this.setBoundsChanged(true);
        this.firePropertyChange(2, "bounds", null, this.bounds);
        int n = this.getChildrenCount();
        for (int i = 0; i < n; ++i) {
            PNode pNode = (PNode)this.children.get(i);
            pNode.parentBoundsChanged();
        }
    }

    protected void parentBoundsChanged() {
    }

    public void invalidateFullBounds() {
        this.setFullBoundsInvalid(true);
        PNode pNode = this.parent;
        while (pNode != null && !pNode.getChildBoundsInvalid()) {
            pNode.setChildBoundsInvalid(true);
            pNode = pNode.parent;
        }
        if (SCENE_GRAPH_DELEGATE != null) {
            SCENE_GRAPH_DELEGATE.nodeFullBoundsInvalidated(this);
        }
    }

    protected boolean validateFullBounds() {
        boolean bl = this.getBoundsVolatile();
        if (this.fullBoundsInvalid || this.childBoundsInvalid || bl || this.childBoundsVolatile) {
            if (bl && !this.boundsChanged) {
                this.signalBoundsChanged();
            }
            if (this.childBoundsInvalid || this.childBoundsVolatile) {
                this.childBoundsVolatile = false;
                int n = this.getChildrenCount();
                for (int i = 0; i < n; ++i) {
                    PNode pNode = (PNode)this.children.get(i);
                    this.childBoundsVolatile |= pNode.validateFullBounds();
                }
            }
            this.layoutChildren();
            if (this.fullBoundsInvalid) {
                boolean bl2;
                double d = this.fullBoundsCache.x;
                double d2 = this.fullBoundsCache.y;
                double d3 = this.fullBoundsCache.width;
                double d4 = this.fullBoundsCache.height;
                boolean bl3 = this.fullBoundsCache.isEmpty();
                this.fullBoundsCache = this.computeFullBounds(this.fullBoundsCache);
                boolean bl4 = bl2 = this.fullBoundsCache.x != d || this.fullBoundsCache.y != d2 || this.fullBoundsCache.width != d3 || this.fullBoundsCache.height != d4 || this.fullBoundsCache.isEmpty() != bl3;
                if (bl2) {
                    if (this.parent != null) {
                        this.parent.invalidateFullBounds();
                    }
                    this.firePropertyChange(4, "fullBounds", null, this.fullBoundsCache);
                    if (this.paintInvalid && !bl3) {
                        TEMP_REPAINT_BOUNDS.setRect(d, d2, d3, d4);
                        this.repaintFrom(TEMP_REPAINT_BOUNDS, this);
                    }
                }
            }
            this.boundsChanged = false;
            this.fullBoundsInvalid = false;
            this.childBoundsInvalid = false;
        }
        return bl || this.childBoundsVolatile;
    }

    protected void layoutChildren() {
    }

    public double getScale() {
        if (this.transform == null) {
            return 1.0;
        }
        return this.transform.getScale();
    }

    public void scale(double d) {
        this.scaleAboutPoint(d, 0.0, 0.0);
    }

    public void scaleAboutPoint(double d, double d2, double d3) {
        this.getTransformReference(true).scaleAboutPoint(d, d2, d3);
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(8, "transform", null, this.transform);
    }

    public Point2D getOffset() {
        if (this.transform == null) {
            return new Point2D.Double();
        }
        return new Point2D.Double(this.transform.getTranslateX(), this.transform.getTranslateY());
    }

    public void setOffset(Point2D point2D) {
        this.setOffset(point2D.getX(), point2D.getY());
    }

    public void setOffset(double d, double d2) {
        this.getTransformReference(true).setOffset(d, d2);
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(8, "transform", null, this.transform);
    }

    public void translate(double d, double d2) {
        this.getTransformReference(true).translate(d, d2);
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(8, "transform", null, this.transform);
    }

    public PAffineTransform getTransform() {
        if (this.transform == null) {
            return new PAffineTransform();
        }
        return (PAffineTransform)this.transform.clone();
    }

    public PAffineTransform getTransformReference(boolean bl) {
        if (this.transform == null && bl) {
            this.transform = new PAffineTransform();
        }
        return this.transform;
    }

    public void setTransform(AffineTransform affineTransform) {
        if (affineTransform == null) {
            this.transform = null;
        } else {
            this.getTransformReference(true).setTransform(affineTransform);
        }
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(8, "transform", null, this.transform);
    }

    public boolean getPaintInvalid() {
        return this.paintInvalid;
    }

    public void setPaintInvalid(boolean bl) {
        this.paintInvalid = bl;
    }

    public boolean getChildPaintInvalid() {
        return this.childPaintInvalid;
    }

    public void setChildPaintInvalid(boolean bl) {
        this.childPaintInvalid = bl;
    }

    public void invalidatePaint() {
        this.setPaintInvalid(true);
        PNode pNode = this.parent;
        while (pNode != null && !pNode.getChildPaintInvalid()) {
            pNode.setChildPaintInvalid(true);
            pNode = pNode.parent;
        }
        if (SCENE_GRAPH_DELEGATE != null) {
            SCENE_GRAPH_DELEGATE.nodePaintInvalidated(this);
        }
    }

    public void validateFullPaint() {
        if (this.getPaintInvalid()) {
            this.repaint();
            this.setPaintInvalid(false);
        }
        if (this.getChildPaintInvalid()) {
            int n = this.getChildrenCount();
            for (int i = 0; i < n; ++i) {
                PNode pNode = (PNode)this.children.get(i);
                pNode.validateFullPaint();
            }
            this.setChildPaintInvalid(false);
        }
    }

    public void repaint() {
        TEMP_REPAINT_BOUNDS.setRect(this.getFullBoundsReference());
        this.repaintFrom(TEMP_REPAINT_BOUNDS, this);
    }

    public void repaintFrom(PBounds pBounds, PNode pNode) {
        if (this.parent != null) {
            if (pNode != this) {
                this.localToParent(pBounds);
            } else if (!this.getVisible()) {
                return;
            }
            this.parent.repaintFrom(pBounds, this);
        }
    }

    public boolean getOccluded() {
        return this.occluded;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (this.getVisible() != bl) {
            if (!bl) {
                this.repaint();
            }
            this.visible = bl;
            this.firePropertyChange(16, "visible", null, null);
            this.invalidatePaint();
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        if (this.paint == paint) {
            return;
        }
        Paint paint2 = this.paint;
        this.paint = paint;
        this.invalidatePaint();
        this.firePropertyChange(32, "paint", paint2, this.paint);
    }

    protected void paint(PPaintContext pPaintContext) {
        if (this.paint != null) {
            Graphics2D graphics2D = pPaintContext.getGraphics();
            graphics2D.setPaint(this.paint);
            graphics2D.fill(this.getBoundsReference());
        }
    }

    public void fullPaint(PPaintContext pPaintContext) {
        if (this.getVisible() && this.fullIntersects(pPaintContext.getLocalClip())) {
            pPaintContext.pushTransform(this.transform);
            pPaintContext.pushTransparency(this.transparency);
            if (!this.getOccluded()) {
                this.paint(pPaintContext);
            }
            int n = this.getChildrenCount();
            for (int i = 0; i < n; ++i) {
                PNode pNode = (PNode)this.children.get(i);
                pNode.fullPaint(pPaintContext);
            }
            this.paintAfterChildren(pPaintContext);
            pPaintContext.popTransparency(this.transparency);
            pPaintContext.popTransform(this.transform);
        }
    }

    protected void paintAfterChildren(PPaintContext pPaintContext) {
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n != 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        PBounds pBounds = this.getFullBounds();
        pBounds.expandNearestIntegerDimensions();
        graphics2D.setClip(0, 0, (int)pageFormat.getWidth(), (int)pageFormat.getHeight());
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        double d = pageFormat.getImageableWidth() / pBounds.getWidth();
        if (pageFormat.getImageableHeight() / pBounds.getHeight() < d) {
            d = pageFormat.getImageableHeight() / pBounds.getHeight();
        }
        graphics2D.scale(d, d);
        graphics2D.translate(-pBounds.x, -pBounds.y);
        PPaintContext pPaintContext = new PPaintContext(graphics2D);
        pPaintContext.setRenderQuality(1);
        this.fullPaint(pPaintContext);
        return 0;
    }

    public boolean getPickable() {
        return this.pickable;
    }

    public void setPickable(boolean bl) {
        if (this.getPickable() != bl) {
            this.pickable = bl;
            this.firePropertyChange(128, "pickable", null, null);
        }
    }

    public boolean getChildrenPickable() {
        return this.childrenPickable;
    }

    public void setChildrenPickable(boolean bl) {
        if (this.getChildrenPickable() != bl) {
            this.childrenPickable = bl;
            this.firePropertyChange(256, "childrenPickable", null, null);
        }
    }

    protected boolean pick(PPickPath pPickPath) {
        return false;
    }

    public boolean fullPick(PPickPath pPickPath) {
        if ((this.getPickable() || this.getChildrenPickable()) && this.fullIntersects(pPickPath.getPickBounds())) {
            boolean bl;
            pPickPath.pushNode(this);
            pPickPath.pushTransform(this.transform);
            boolean bl2 = bl = this.getPickable() && pPickPath.acceptsNode(this);
            if (bl && this.pick(pPickPath)) {
                return true;
            }
            if (this.getChildrenPickable()) {
                int n = this.getChildrenCount();
                for (int i = n - 1; i >= 0; --i) {
                    PNode pNode = (PNode)this.children.get(i);
                    if (!pNode.fullPick(pPickPath)) continue;
                    return true;
                }
            }
            if (bl && this.pickAfterChildren(pPickPath)) {
                return true;
            }
            pPickPath.popTransform(this.transform);
            pPickPath.popNode(this);
        }
        return false;
    }

    protected boolean pickAfterChildren(PPickPath pPickPath) {
        return this.intersects(pPickPath.getPickBounds());
    }

    public void addChild(PNode pNode) {
        int n = this.getChildrenCount();
        if (pNode.parent == this) {
            --n;
        }
        this.addChild(n, pNode);
    }

    public void addChild(int n, PNode pNode) {
        PNode pNode2 = pNode.getParent();
        if (pNode2 != null) {
            pNode2.removeChild(pNode);
        }
        pNode.setParent(this);
        this.getChildrenReference().add(n, pNode);
        pNode.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(512, "children", null, this.children);
    }

    public boolean isDescendentOf(PNode pNode) {
        PNode pNode2 = this.parent;
        while (pNode2 != null) {
            if (pNode2 == pNode) {
                return true;
            }
            pNode2 = pNode2.parent;
        }
        return false;
    }

    public boolean isDescendentOfRoot() {
        return this.getRoot() != null;
    }

    public PNode getParent() {
        return this.parent;
    }

    public void setParent(PNode pNode) {
        PNode pNode2 = this.parent;
        this.parent = pNode;
        this.firePropertyChange(1024, "parent", pNode2, this.parent);
    }

    public int indexOfChild(PNode pNode) {
        if (this.children == null) {
            return -1;
        }
        return this.children.indexOf(pNode);
    }

    public PNode removeChild(PNode pNode) {
        return this.removeChild(this.indexOfChild(pNode));
    }

    public PNode removeChild(int n) {
        PNode pNode = (PNode)this.children.remove(n);
        if (this.children.size() == 0) {
            this.children = null;
        }
        pNode.repaint();
        pNode.setParent(null);
        this.invalidateFullBounds();
        this.firePropertyChange(512, "children", null, this.children);
        return pNode;
    }

    public int getChildrenCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public PNode getChild(int n) {
        return (PNode)this.children.get(n);
    }

    public List getChildrenReference() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    public PRoot getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return null;
    }

    public Collection getAllNodes(PNodeFilter pNodeFilter, Collection arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList<PNode>();
        }
        if (pNodeFilter == null || pNodeFilter.accept(this)) {
            arrayList.add(this);
        }
        if (pNodeFilter == null || pNodeFilter.acceptChildrenOf(this)) {
            int n = this.getChildrenCount();
            for (int i = 0; i < n; ++i) {
                PNode pNode = (PNode)this.children.get(i);
                pNode.getAllNodes(pNodeFilter, arrayList);
            }
        }
        return arrayList;
    }

    public String toString() {
        String string = super.toString().replaceAll(".*\\.", "");
        return string + "[" + this.paramString() + "]";
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("bounds=" + (this.bounds == null ? "null" : this.bounds.toString()));
        stringBuffer.append(",fullBounds=" + (this.fullBoundsCache == null ? "null" : this.fullBoundsCache.toString()));
        stringBuffer.append(",transform=" + (this.transform == null ? "null" : this.transform.toString()));
        stringBuffer.append(",paint=" + (this.paint == null ? "null" : this.paint.toString()));
        stringBuffer.append(",transparency=" + this.transparency);
        stringBuffer.append(",childrenCount=" + this.getChildrenCount());
        if (this.fullBoundsInvalid) {
            stringBuffer.append(",fullBoundsInvalid");
        }
        if (this.pickable) {
            stringBuffer.append(",pickable");
        }
        if (this.childrenPickable) {
            stringBuffer.append(",childrenPickable");
        }
        if (this.visible) {
            stringBuffer.append(",visible");
        }
        return stringBuffer.toString();
    }

    public static interface PSceneGraphDelegate {
        public void nodePaintInvalidated(PNode var1);

        public void nodeFullBoundsInvalidated(PNode var1);
    }
}

