/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public class PImage
extends PNode {
    private transient Image image;

    public PImage() {
    }

    public PImage(Image image) {
        this();
        this.setImage(image);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        Image image2 = this.image;
        if (image == null || image instanceof BufferedImage) {
            this.image = image;
        } else {
            ImageIcon imageIcon = new ImageIcon(image);
            switch (imageIcon.getImageLoadStatus()) {
                case 1: {
                    System.err.println("media tracker still loading image after requested to wait until finished");
                }
                case 8: {
                    this.image = imageIcon.getImage();
                    break;
                }
                case 2: {
                    System.err.println("media tracker aborted image load");
                    this.image = null;
                    break;
                }
                case 4: {
                    System.err.println("media tracker errored image load");
                    this.image = null;
                }
            }
        }
        if (this.image != null) {
            this.setBounds(0.0, 0.0, this.getImage().getWidth(null), this.getImage().getHeight(null));
            this.invalidatePaint();
        } else {
            this.image = null;
        }
        this.firePropertyChange(32768, "image", image2, this.image);
    }

    protected void paint(PPaintContext pPaintContext) {
        if (this.getImage() != null) {
            double d = this.image.getWidth(null);
            double d2 = this.image.getHeight(null);
            PBounds pBounds = this.getBoundsReference();
            Graphics2D graphics2D = pPaintContext.getGraphics();
            if (pBounds.x != 0.0 || pBounds.y != 0.0 || pBounds.width != d || pBounds.height != d2) {
                graphics2D.translate(pBounds.x, pBounds.y);
                graphics2D.scale(pBounds.width / d, pBounds.height / d2);
                graphics2D.drawImage(this.image, 0, 0, null);
                graphics2D.scale(d / pBounds.width, d2 / pBounds.height);
                graphics2D.translate(-pBounds.x, -pBounds.y);
            } else {
                graphics2D.drawImage(this.image, 0, 0, null);
            }
        }
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("image=" + (this.image == null ? "null" : this.image.toString()));
        stringBuffer.append(',');
        stringBuffer.append(super.paramString());
        return stringBuffer.toString();
    }
}

