/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;

public class PText
extends PNode {
    public static Font DEFAULT_FONT = new Font("Helvetica", 0, 12);
    public static double DEFAULT_GREEK_THRESHOLD = 5.5;
    public static int NO_WRAP = 1;
    public static int WRAP = 2;
    public static int WRAP_CLIP = 3;
    private String text;
    private Paint textPaint;
    private Font font;
    protected double greekThreshold = DEFAULT_GREEK_THRESHOLD;
    private float justification = 0.0f;
    private boolean constrainHeightToTextHeight = true;
    private boolean constrainWidthToTextWidth = true;
    private transient TextLayout[] lines;
    private static final TextLayout[] EMPTY_TEXT_LAYOUT_ARRAY = new TextLayout[0];

    public PText() {
        this.setTextPaint(Color.BLACK);
    }

    public PText(String string) {
        this();
        this.setText(string);
    }

    public void setTextPaint(Paint paint) {
        this.textPaint = paint;
        this.invalidatePaint();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        String string2 = this.text;
        this.text = string;
        this.lines = null;
        this.recomputeLayout();
        this.invalidatePaint();
        this.firePropertyChange(524288, "text", string2, this.text);
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = DEFAULT_FONT;
        }
        return this.font;
    }

    public void setFont(Font font) {
        Font font2 = this.font;
        this.font = font;
        this.lines = null;
        this.recomputeLayout();
        this.invalidatePaint();
        this.firePropertyChange(0x100000, "font", font2, this.font);
    }

    public void recomputeLayout() {
        ArrayList<TextLayout> arrayList = new ArrayList<TextLayout>();
        double d = 0.0;
        double d2 = 0.0;
        if (this.text != null && this.text.length() > 0) {
            AttributedString attributedString = new AttributedString(this.text);
            attributedString.addAttribute(TextAttribute.FONT, this.getFont());
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, PPaintContext.RENDER_QUALITY_HIGH_FRC);
            float f = this.constrainWidthToTextWidth ? Float.MAX_VALUE : (float)this.getWidth();
            int n = this.text.indexOf(10);
            n = n == -1 ? Integer.MAX_VALUE : ++n;
            while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                TextLayout textLayout = this.computeNextLayout(lineBreakMeasurer, f, n);
                if (n == lineBreakMeasurer.getPosition()) {
                    n = this.text.indexOf(10, lineBreakMeasurer.getPosition());
                    n = n == -1 ? Integer.MAX_VALUE : ++n;
                }
                arrayList.add(textLayout);
                d2 += (double)textLayout.getAscent();
                d2 += (double)(textLayout.getDescent() + textLayout.getLeading());
                d = Math.max(d, (double)textLayout.getAdvance());
            }
        }
        this.lines = arrayList.toArray(EMPTY_TEXT_LAYOUT_ARRAY);
        if (this.constrainWidthToTextWidth || this.constrainHeightToTextHeight) {
            double d3 = this.getWidth();
            double d4 = this.getHeight();
            if (this.constrainWidthToTextWidth) {
                d3 = d;
            }
            if (this.constrainHeightToTextHeight) {
                d4 = d2;
            }
            super.setBounds(this.getX(), this.getY(), d3, d4);
        }
    }

    protected TextLayout computeNextLayout(LineBreakMeasurer lineBreakMeasurer, float f, int n) {
        return lineBreakMeasurer.nextLayout(f, n, false);
    }

    protected void paint(PPaintContext pPaintContext) {
        super.paint(pPaintContext);
        float f = (float)this.getFont().getSize() * (float)pPaintContext.getScale();
        if (this.textPaint != null && (double)f > this.greekThreshold) {
            float f2 = (float)this.getX();
            float f3 = (float)this.getY();
            float f4 = (float)this.getHeight() + f3;
            Graphics2D graphics2D = pPaintContext.getGraphics();
            if (this.lines == null) {
                this.recomputeLayout();
                this.repaint();
                return;
            }
            graphics2D.setPaint(this.textPaint);
            for (int i = 0; i < this.lines.length; ++i) {
                TextLayout textLayout = this.lines[i];
                if (f4 < (f3 += textLayout.getAscent())) {
                    return;
                }
                float f5 = (float)(this.getWidth() - (double)textLayout.getAdvance()) * this.justification;
                textLayout.draw(graphics2D, f2 + f5, f3);
                f3 += textLayout.getDescent() + textLayout.getLeading();
            }
        }
    }

    protected void internalUpdateBounds(double d, double d2, double d3, double d4) {
        this.recomputeLayout();
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("text=" + (this.text == null ? "null" : this.text));
        stringBuffer.append(",font=" + (this.font == null ? "null" : this.font.toString()));
        stringBuffer.append(',');
        stringBuffer.append(super.paramString());
        return stringBuffer.toString();
    }
}

