/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.pswing;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import edu.umd.cs.piccolox.pswing.PSwingRepaintManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.RepaintManager;

public class PSwing
extends PNode
implements Serializable,
PropertyChangeListener {
    private static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();
    private static PBounds TEMP_REPAINT_BOUNDS2 = new PBounds();
    private double renderCutoff = 0.3;
    private JComponent component = null;
    private double minFontSize = Double.MAX_VALUE;
    private Stroke defaultStroke = new BasicStroke();
    private Font defaultFont = new Font("Serif", 0, 12);
    private BufferedImage buffer;
    private static final Color BUFFER_BACKGROUND_COLOR = new Color(0, 0, 0, 0);
    private PSwingCanvas canvas;
    private ArrayList listeningTo = new ArrayList();
    private PropertyChangeListener parentListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PNode pNode = (PNode)propertyChangeEvent.getSource();
            PNode pNode2 = pNode.getParent();
            if (pNode2 != null) {
                PSwing.this.listenForCanvas(pNode2);
            }
        }
    };

    public PSwing(JComponent jComponent) {
        this.component = jComponent;
        jComponent.putClientProperty("PSwing", this);
        this.init(jComponent);
        jComponent.revalidate();
        jComponent.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PSwing.this.reshape();
            }
        });
        this.reshape();
        this.listenForCanvas(this);
    }

    void reshape() {
        this.component.setBounds(0, 0, this.component.getPreferredSize().width, this.component.getPreferredSize().height);
        this.setBounds(0.0, 0.0, this.component.getPreferredSize().width, this.component.getPreferredSize().height);
    }

    public void paint(PPaintContext pPaintContext) {
        Graphics2D graphics2D = pPaintContext.getGraphics();
        if (this.defaultStroke == null) {
            this.defaultStroke = new BasicStroke();
        }
        graphics2D.setStroke(this.defaultStroke);
        if (this.defaultFont == null) {
            this.defaultFont = new Font("Serif", 0, 12);
        }
        graphics2D.setFont(this.defaultFont);
        if (this.component.getParent() == null) {
            this.component.revalidate();
        }
        if (this.shouldRenderGreek(pPaintContext)) {
            this.paintAsGreek(graphics2D);
        } else {
            this.paint(graphics2D);
        }
    }

    protected boolean shouldRenderGreek(PPaintContext pPaintContext) {
        return pPaintContext.getScale() < this.renderCutoff || this.minFontSize * pPaintContext.getScale() < 0.5;
    }

    public void paintAsGreek(Graphics2D graphics2D) {
        Color color = this.component.getBackground();
        Color color2 = this.component.getForeground();
        PBounds pBounds = this.getBounds();
        if (color != null) {
            graphics2D.setColor(color);
        }
        graphics2D.fill(pBounds);
        if (color2 != null) {
            graphics2D.setColor(color2);
        }
        graphics2D.draw(pBounds);
    }

    public void paint(Graphics2D graphics2D) {
        if (this.component.getBounds().isEmpty()) {
            return;
        }
        PSwingRepaintManager pSwingRepaintManager = (PSwingRepaintManager)RepaintManager.currentManager(this.component);
        pSwingRepaintManager.lockRepaint(this.component);
        Graphics2D graphics2D2 = null;
        if (!this.isBufferValid()) {
            this.buffer = new BufferedImage(this.component.getWidth(), this.component.getHeight(), 3);
            graphics2D2 = this.buffer.createGraphics();
        } else {
            graphics2D2 = this.buffer.createGraphics();
            graphics2D2.setBackground(BUFFER_BACKGROUND_COLOR);
            graphics2D2.clearRect(0, 0, this.component.getWidth(), this.component.getHeight());
        }
        graphics2D2.setRenderingHints(graphics2D.getRenderingHints());
        graphics2D2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        this.component.paint(graphics2D2);
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        if (graphics2D.getTransform().getScaleX() == 1.0 && graphics2D.getTransform().getScaleY() == 1.0) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
        graphics2D.drawRenderedImage(this.buffer, IDENTITY_TRANSFORM);
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
        }
        pSwingRepaintManager.unlockRepaint(this.component);
    }

    private boolean isBufferValid() {
        return this.buffer != null && this.buffer.getWidth() == this.component.getWidth() && this.buffer.getHeight() == this.component.getHeight();
    }

    public void repaint(PBounds pBounds) {
        Shape shape = this.getTransform().createTransformedShape(pBounds);
        TEMP_REPAINT_BOUNDS2.setRect(shape.getBounds2D());
        this.repaintFrom(TEMP_REPAINT_BOUNDS2, this);
    }

    public void computeBounds() {
        this.reshape();
    }

    public JComponent getComponent() {
        return this.component;
    }

    void init(Component component) {
        Component[] componentArray = null;
        if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (component.getFont() != null) {
            this.minFontSize = Math.min(this.minFontSize, (double)component.getFont().getSize());
        }
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                this.init(componentArray[i]);
            }
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setDoubleBuffered(false);
            component.addPropertyChangeListener("font", this);
            component.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    PSwing.this.computeBounds();
                }

                public void componentShown(ComponentEvent componentEvent) {
                    PSwing.this.computeBounds();
                }
            });
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.component.isAncestorOf((Component)propertyChangeEvent.getSource()) && ((Component)propertyChangeEvent.getSource()).getFont() != null) {
            this.minFontSize = Math.min(this.minFontSize, (double)((Component)propertyChangeEvent.getSource()).getFont().getSize());
        }
    }

    private void listenForCanvas(PNode pNode) {
        block0: for (PNode pNode2 = pNode; pNode2 != null; pNode2 = pNode2.getParent()) {
            this.listenToNode(pNode2);
            PNode pNode3 = pNode2;
            if (!(pNode3 instanceof PLayer)) continue;
            PLayer pLayer = (PLayer)pNode3;
            for (int i = 0; i < pLayer.getCameraCount(); ++i) {
                PCamera pCamera = pLayer.getCamera(i);
                if (!(pCamera.getComponent() instanceof PSwingCanvas)) continue;
                this.updateCanvas((PSwingCanvas)pCamera.getComponent());
                continue block0;
            }
        }
    }

    private void listenToNode(PNode pNode) {
        if (!this.listeningTo(pNode)) {
            this.listeningTo.add(pNode);
            pNode.addPropertyChangeListener("parent", this.parentListener);
        }
    }

    private boolean listeningTo(PNode pNode) {
        for (int i = 0; i < this.listeningTo.size(); ++i) {
            PNode pNode2 = (PNode)this.listeningTo.get(i);
            if (pNode2 != pNode) continue;
            return true;
        }
        return false;
    }

    private void updateCanvas(PSwingCanvas pSwingCanvas) {
        if (pSwingCanvas != this.canvas) {
            if (this.canvas != null) {
                this.canvas.removePSwing(this);
            }
            if (pSwingCanvas != null) {
                this.canvas = pSwingCanvas;
                this.canvas.addPSwing(this);
                this.reshape();
                this.repaint();
                this.canvas.invalidate();
                this.canvas.revalidate();
                this.canvas.repaint();
            }
        }
    }
}

