/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.NoBodyOutputStream;

class NoBodyResponse
implements HttpServletResponse {
    private HttpServletResponse resp;
    private NoBodyOutputStream noBody;
    private PrintWriter writer;
    private boolean didSetContentLength;

    NoBodyResponse(HttpServletResponse r) {
        this.resp = r;
        this.noBody = new NoBodyOutputStream();
    }

    void setContentLength() {
        if (!this.didSetContentLength) {
            this.resp.setContentLength(this.noBody.getContentLength());
        }
    }

    public void setContentLength(int len) {
        this.resp.setContentLength(len);
        this.didSetContentLength = true;
    }

    public void setContentType(String type) {
        this.resp.setContentType(type);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.noBody;
    }

    public String getCharacterEncoding() {
        return this.resp.getCharacterEncoding();
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.writer == null) {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)this.noBody, this.getCharacterEncoding());
            this.writer = new PrintWriter(w);
        }
        return this.writer;
    }

    public boolean containsHeader(String name) {
        return this.resp.containsHeader(name);
    }

    public void setStatus(int sc) {
        this.resp.setStatus(sc);
    }

    public void setHeader(String name, String value) {
        this.resp.setHeader(name, value);
    }

    public void setDateHeader(String name, long date) {
        this.resp.setDateHeader(name, date);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.resp.sendError(sc, msg);
    }
}

