/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.jfreechartphet.piccolo.dynamic;

import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.DynamicJFreeChartNode;
import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.SeriesData;
import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.SeriesView;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class BufferedSeriesView
extends SeriesView {
    public static final BasicStroke DEFAULT_STROKE = new BasicStroke(3.0f, 1, 0, 1.0f);
    private PhetPPath debugRegion = new PhetPPath(new BasicStroke(3.0f), (Paint)Color.blue);
    private boolean updateAllEnabled = false;
    private double lastLineLength = 0.0;

    public void visibilityChanged() {
        this.paintAll();
    }

    public BufferedSeriesView(DynamicJFreeChartNode dynamicJFreeChartNode, SeriesData seriesData) {
        super(dynamicJFreeChartNode, seriesData);
        dynamicJFreeChartNode.addBufferedImagePropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BufferedSeriesView.this.paintAll();
            }
        });
        dynamicJFreeChartNode.getPhetPCanvas().addScreenChild(this.debugRegion);
        dynamicJFreeChartNode.getPhetPCanvas().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                BufferedSeriesView.this.paintAll();
            }
        });
    }

    public void dataAdded() {
        if (this.getSeries().getItemCount() >= 2 && this.getDynamicJFreeChartNode().getBuffer() != null && this.getSeriesData().isVisible() && this.getDynamicJFreeChartNode().getVisible() && this.getDynamicJFreeChartNode().isDescendentOfRoot()) {
            this.drawPoint(0);
        }
    }

    public void dataCleared() {
    }

    private void drawPoint(int n) {
        this.updateStroke();
        BufferedImage bufferedImage = this.getDynamicJFreeChartNode().getBuffer();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(this.getSeriesData().getColor());
        graphics2D.setStroke(this.getSeriesData().getStroke());
        int n2 = this.getSeries().getItemCount();
        Line2D.Double double_ = new Line2D.Double(this.getNodePoint(n2 - 2 - n), this.getNodePoint(n2 - 1 - n));
        this.lastLineLength = double_.getP1().distance(double_.getP2());
        this.setupRenderingHints(graphics2D);
        graphics2D.clip(this.translateDataArea());
        graphics2D.draw(double_);
        Shape shape = this.getSeriesData().getStroke().createStrokedShape(double_);
        Rectangle2D rectangle2D = shape.getBounds2D();
        this.getDynamicJFreeChartNode().localToGlobal(rectangle2D);
        this.getDynamicJFreeChartNode().getPhetPCanvas().getPhetRootNode().globalToScreen(rectangle2D);
        this.repaintPanel(this.translateDown(rectangle2D));
    }

    private void updateStroke() {
        BasicStroke basicStroke;
        Stroke stroke = this.getSeriesData().getStroke();
        if (stroke instanceof BasicStroke && (basicStroke = (BasicStroke)stroke).getDashArray() != null) {
            this.getSeriesData().setStroke(new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), (float)((double)basicStroke.getDashPhase() + this.lastLineLength)));
        }
    }

    private void resetStrokePhase() {
        BasicStroke basicStroke;
        Stroke stroke = this.getSeriesData().getStroke();
        if (stroke instanceof BasicStroke && (basicStroke = (BasicStroke)stroke).getDashArray() != null) {
            this.getSeriesData().setStroke(new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), 0.0f));
        }
    }

    private Rectangle2D translateDown(Rectangle2D rectangle2D) {
        return new Rectangle2D.Double(rectangle2D.getX() + this.getDX(), rectangle2D.getY() + this.getDY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    private Shape translateDataArea() {
        Rectangle2D rectangle2D = this.getDataArea();
        return new Rectangle2D.Double(rectangle2D.getX() - this.getDX(), rectangle2D.getY() - this.getDY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    private double getDX() {
        return this.getDynamicJFreeChartNode().getBounds().getX();
    }

    private double getDY() {
        return this.getDynamicJFreeChartNode().getBounds().getY();
    }

    public Point2D getNodePoint(int n) {
        return new Point2D.Double(super.getNodePoint(n).getX() - this.getDX(), super.getNodePoint(n).getY() - this.getDY());
    }

    protected void forceRepaintAll() {
        BufferedImage bufferedImage = this.getDynamicJFreeChartNode().getBuffer();
        if (bufferedImage != null) {
            this.lastLineLength = 0.0;
            this.updateStroke();
            this.resetStrokePhase();
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setPaint(this.getSeriesData().getColor());
            graphics2D.setStroke(this.getSeriesData().getStroke());
            this.setupRenderingHints(graphics2D);
            graphics2D.clip(this.getDataArea());
            if (this.getSeriesData().isVisible()) {
                graphics2D.draw(this.translateDown(this.toGeneralPath()));
            }
        }
    }

    private void setupRenderingHints(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public void install() {
        super.install();
        this.getDynamicJFreeChartNode().updateAll();
    }

    public void uninstall() {
        super.uninstall();
    }

    private void paintAll() {
        if (this.updateAllEnabled) {
            this.forceRepaintAll();
        }
    }

    private Shape translateDown(GeneralPath generalPath) {
        return AffineTransform.getTranslateInstance(this.getDX(), this.getDY()).createTransformedShape(generalPath);
    }

    protected void repaintPanel(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.getDataArea();
        this.getDynamicJFreeChartNode().localToGlobal(rectangle2D2);
        Rectangle2D rectangle2D3 = rectangle2D.createIntersection(rectangle2D2);
        this.getDynamicJFreeChartNode().getPhetPCanvas().repaint(new PBounds(rectangle2D3));
    }
}

