/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.jfreechartphet.piccolo.dynamic;

import edu.colorado.phet.common.jfreechartphet.piccolo.JFreeChartNode;
import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.BoundedPPathSeriesView;
import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.BufferedImmediateSeriesView;
import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.BufferedSeriesView;
import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.ImmediateBoundedPPathSeriesView;
import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.JFreeChartSeriesView;
import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.PPathSeriesView;
import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.SeriesData;
import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.SeriesView;
import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.SeriesViewFactory;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.jfree.chart.JFreeChart;

public class DynamicJFreeChartNode
extends JFreeChartNode {
    private ArrayList seriesDataList = new ArrayList();
    private ArrayList seriesViewList = new ArrayList();
    private PhetPCanvas phetPCanvas;
    private SeriesViewFactory viewFactory = RENDERER_JFREECHART;
    private boolean autoUpdateAll = true;
    public static final SeriesViewFactory RENDERER_JFREECHART = new SeriesViewFactory(){

        public SeriesView createSeriesView(DynamicJFreeChartNode dynamicJFreeChartNode, SeriesData seriesData) {
            return new JFreeChartSeriesView(dynamicJFreeChartNode, seriesData);
        }
    };
    public static final SeriesViewFactory RENDERER_BUFFERED = new SeriesViewFactory(){

        public SeriesView createSeriesView(DynamicJFreeChartNode dynamicJFreeChartNode, SeriesData seriesData) {
            return new BufferedSeriesView(dynamicJFreeChartNode, seriesData);
        }
    };
    public static final SeriesViewFactory RENDERER_PICCOLO = new SeriesViewFactory(){

        public SeriesView createSeriesView(DynamicJFreeChartNode dynamicJFreeChartNode, SeriesData seriesData) {
            return new PPathSeriesView(dynamicJFreeChartNode, seriesData);
        }
    };
    public static final SeriesViewFactory RENDERER_BUFFERED_IMMEDIATE = new SeriesViewFactory(){

        public SeriesView createSeriesView(DynamicJFreeChartNode dynamicJFreeChartNode, SeriesData seriesData) {
            return new BufferedImmediateSeriesView(dynamicJFreeChartNode, seriesData);
        }
    };
    public static final SeriesViewFactory RENDERER_PICCOLO_INCREMENTAL_IMMEDIATE = new SeriesViewFactory(){

        public SeriesView createSeriesView(DynamicJFreeChartNode dynamicJFreeChartNode, SeriesData seriesData) {
            return new ImmediateBoundedPPathSeriesView(dynamicJFreeChartNode, seriesData);
        }
    };
    public static final SeriesViewFactory RENDERER_PICCOLO_INCREMENTAL = new SeriesViewFactory(){

        public SeriesView createSeriesView(DynamicJFreeChartNode dynamicJFreeChartNode, SeriesData seriesData) {
            return new BoundedPPathSeriesView(dynamicJFreeChartNode, seriesData);
        }
    };

    public DynamicJFreeChartNode(PhetPCanvas phetPCanvas, JFreeChart jFreeChart) {
        super(jFreeChart);
        this.phetPCanvas = phetPCanvas;
    }

    public void setAutoUpdateAll(boolean bl) {
        this.autoUpdateAll = bl;
    }

    public void forceUpdateAll() {
        super.updateAll();
        for (int i = 0; i < this.seriesViewList.size(); ++i) {
            SeriesView seriesView = (SeriesView)this.seriesViewList.get(i);
            seriesView.forceRepaintAll();
        }
    }

    public void updateAll() {
        if (this.autoUpdateAll) {
            super.updateAll();
        }
    }

    protected void addPNodeUpdateHandler() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            }
        });
    }

    public void addValue(double d, double d2) {
        this.addValue(0, d, d2);
    }

    public void addValue(int n, double d, double d2) {
        this.getSeries(n).addValue(d, d2);
    }

    public void addSeries(String string, Color color) {
        this.addSeries(string, color, BufferedSeriesView.DEFAULT_STROKE);
    }

    public SeriesData addSeries(String string, Color color, Stroke stroke) {
        SeriesData seriesData = new SeriesData(string, color, stroke);
        this.seriesDataList.add(seriesData);
        this.updateSeriesViews();
        return seriesData;
    }

    public void clear() {
        for (int i = 0; i < this.seriesDataList.size(); ++i) {
            SeriesData seriesData = (SeriesData)this.seriesDataList.get(i);
            seriesData.clear();
        }
        this.updateAll();
    }

    public SeriesData getSeries(int n) {
        return (SeriesData)this.seriesDataList.get(n);
    }

    public void setJFreeChartSeries() {
        this.setViewFactory(RENDERER_JFREECHART);
    }

    public SeriesViewFactory getViewFactory() {
        return this.viewFactory;
    }

    public void setPiccoloSeries() {
        this.setViewFactory(RENDERER_PICCOLO);
    }

    public void setBufferedSeries() {
        this.setViewFactory(RENDERER_BUFFERED);
    }

    public void setBufferedImmediateSeries() {
        this.setViewFactory(RENDERER_BUFFERED_IMMEDIATE);
    }

    public void setViewFactory(SeriesViewFactory seriesViewFactory) {
        this.viewFactory = seriesViewFactory;
        this.updateSeriesViews();
        this.forceUpdateAll();
    }

    private void updateSeriesViews() {
        this.removeAllSeriesViews();
        this.updateAll();
        this.addAllSeriesViews();
        this.updateChartRenderingInfo();
    }

    private void addAllSeriesViews() {
        for (int i = 0; i < this.seriesDataList.size(); ++i) {
            SeriesData seriesData = (SeriesData)this.seriesDataList.get(i);
            SeriesView seriesView = this.viewFactory.createSeriesView(this, seriesData);
            seriesView.install();
            this.seriesViewList.add(seriesView);
        }
    }

    private void removeAllSeriesViews() {
        while (this.seriesViewList.size() > 0) {
            SeriesView seriesView = (SeriesView)this.seriesViewList.get(0);
            seriesView.uninstall();
            this.seriesViewList.remove(seriesView);
        }
    }

    public void setBuffered(boolean bl) {
        super.setBuffered(bl);
        this.updateSeriesViews();
    }

    public PhetPCanvas getPhetPCanvas() {
        return this.phetPCanvas;
    }

    public void addBufferedImagePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addBufferedImagePropertyChangeListener(propertyChangeListener);
    }

    public void removeBufferedImagePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removeBufferedImagePropertyChangeListener(propertyChangeListener);
    }

    public BufferedImage getBuffer() {
        return super.getBuffer();
    }

    public void setSeriesVisible(SeriesData seriesData, boolean bl) {
        seriesData.setVisible(bl);
        this.updateSeriesViews();
    }
}

