/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.jfreechartphet.piccolo.dynamic;

import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.DynamicJFreeChartNode;
import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.DynamicJFreeChartNodeControlPanel;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.umd.cs.piccolo.util.PDebug;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeriesCollection;

public class TestDynamicJFreeChartNode {
    private JFrame frame;
    private Timer timer;
    private double t0 = System.currentTimeMillis();
    private PhetPCanvas phetPCanvas;
    private DynamicJFreeChartNode dynamicJFreeChartNode;
    private PSwing pSwing;

    public TestDynamicJFreeChartNode() {
        this.frame = new JFrame();
        this.frame.setSize(1280, 668);
        this.frame.setDefaultCloseOperation(3);
        this.phetPCanvas = new PhetPCanvas();
        this.frame.setContentPane(this.phetPCanvas);
        JFreeChart jFreeChart = ChartFactory.createXYLineChart("title", "x", "y", new XYSeriesCollection(), PlotOrientation.VERTICAL, false, false, false);
        this.dynamicJFreeChartNode = new DynamicJFreeChartNode(this.phetPCanvas, jFreeChart);
        this.dynamicJFreeChartNode.addSeries("sine", Color.blue);
        jFreeChart.getXYPlot().getRangeAxis().setAutoRange(false);
        jFreeChart.getXYPlot().getRangeAxis().setRange(-1.0, 1.0);
        jFreeChart.getXYPlot().getDomainAxis().setAutoRange(false);
        jFreeChart.getXYPlot().getDomainAxis().setRange(0.0, 1.0);
        this.phetPCanvas.addScreenChild(this.dynamicJFreeChartNode);
        JPanel jPanel = new JPanel();
        DynamicJFreeChartNodeControlPanel dynamicJFreeChartNodeControlPanel = new DynamicJFreeChartNodeControlPanel(this.dynamicJFreeChartNode);
        JButton jButton = new JButton("Clear");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestDynamicJFreeChartNode.this.clear();
            }
        });
        jPanel.add(dynamicJFreeChartNodeControlPanel);
        jPanel.add(jButton);
        this.pSwing = new PSwing(jPanel);
        this.phetPCanvas.addScreenChild(this.pSwing);
        this.timer = new Timer(30, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestDynamicJFreeChartNode.this.updateGraph();
            }
        });
        this.phetPCanvas.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 112 && keyEvent.isAltDown()) {
                    PDebug.debugRegionManagement = !PDebug.debugRegionManagement;
                }
            }
        });
        this.phetPCanvas.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                TestDynamicJFreeChartNode.this.phetPCanvas.requestFocus();
            }
        });
        this.phetPCanvas.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                TestDynamicJFreeChartNode.this.relayout();
            }
        });
        this.relayout();
    }

    protected void updateGraph() {
        double d = ((double)System.currentTimeMillis() - this.t0) / 500.0;
        double d2 = 0.1;
        double d3 = Math.sin(d * 2.0 * Math.PI * d2);
        Point2D.Double double_ = new Point2D.Double(d / 100.0, d3);
        this.dynamicJFreeChartNode.addValue(double_.getX(), double_.getY());
    }

    public DynamicJFreeChartNode getDynamicJFreeChartNode() {
        return this.dynamicJFreeChartNode;
    }

    public PhetPCanvas getPhetPCanvas() {
        return this.phetPCanvas;
    }

    public PSwing getPSwing() {
        return this.pSwing;
    }

    private void clear() {
        this.dynamicJFreeChartNode.clear();
        this.t0 = System.currentTimeMillis();
    }

    protected void relayout() {
        this.pSwing.setOffset(0.0, 0.0);
        this.dynamicJFreeChartNode.setBounds(0.0, this.pSwing.getFullBounds().getHeight(), this.phetPCanvas.getWidth(), (double)this.phetPCanvas.getHeight() - this.pSwing.getFullBounds().getHeight());
    }

    public void start() {
        this.frame.setVisible(true);
        this.timer.start();
        this.phetPCanvas.requestFocus();
    }

    public static void main(String[] stringArray) {
        new TestDynamicJFreeChartNode().start();
    }
}

