/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion;

import JSci.maths.LinearMath;
import JSci.maths.vectors.AbstractDoubleVector;
import edu.colorado.phet.common.motion.model.TimeData;

public class MotionMath {
    public static double estimateDerivative(TimeData[] timeDataArray) {
        double[] dArray = new double[timeDataArray.length];
        double[] dArray2 = new double[timeDataArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray[i] = timeDataArray[i].getTime();
            dArray2[i] = timeDataArray[i].getValue();
        }
        double[][] dArray3 = new double[2][timeDataArray.length];
        dArray3[0] = dArray;
        dArray3[1] = dArray2;
        AbstractDoubleVector abstractDoubleVector = LinearMath.linearRegression(dArray3);
        if (Double.isNaN(abstractDoubleVector.getComponent(1)) || Double.isInfinite(abstractDoubleVector.getComponent(1))) {
            return 0.0;
        }
        return abstractDoubleVector.getComponent(1);
    }

    public static double averageTime(TimeData[] timeDataArray) {
        double d = 0.0;
        for (int i = 0; i < timeDataArray.length; ++i) {
            d += timeDataArray[i].getTime();
        }
        return d / (double)timeDataArray.length;
    }

    public static TimeData getDerivative(TimeData[] timeDataArray) {
        if (timeDataArray.length == 0) {
            return new TimeData(0.0, 0.0);
        }
        return new TimeData(MotionMath.estimateDerivative(timeDataArray), MotionMath.averageTime(timeDataArray));
    }

    public static TimeData[] smooth(TimeData[] timeDataArray, int n) {
        for (int i = 0; i < n; ++i) {
            timeDataArray = MotionMath.smooth(timeDataArray);
        }
        return timeDataArray;
    }

    private static TimeData[] smooth(TimeData[] timeDataArray) {
        TimeData[] timeDataArray2 = new TimeData[timeDataArray.length];
        for (int i = 0; i < timeDataArray2.length; ++i) {
            timeDataArray2[i] = i > 0 && i < timeDataArray2.length - 1 ? new TimeData((timeDataArray[i - 1].getValue() + timeDataArray[i].getValue() + timeDataArray[i + 1].getValue()) / 3.0, timeDataArray[i].getTime()) : new TimeData(timeDataArray[i].getValue(), timeDataArray[i].getTime());
        }
        return timeDataArray2;
    }
}

