/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.graphs;

import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.BufferedSeriesView;
import edu.colorado.phet.common.motion.model.ISimulationVariable;
import edu.colorado.phet.common.motion.model.ITimeSeries;
import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;

public class ControlGraphSeries {
    private String title;
    private Color color;
    private String abbr;
    private String units;
    private ISimulationVariable simulationVariable;
    private ITimeSeries observableTimeSeries;
    private boolean visible = true;
    private Stroke stroke;
    private boolean editable;
    private String character;
    private ArrayList listeners = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public ControlGraphSeries(String string, Color color, String string2, String string3, ISimulationVariable iSimulationVariable, ITimeSeries iTimeSeries, String string4) {
        this(string, color, string2, string3, iSimulationVariable, iTimeSeries, BufferedSeriesView.DEFAULT_STROKE, string4);
    }

    public ControlGraphSeries(String string, Color color, String string2, String string3, ISimulationVariable iSimulationVariable, ITimeSeries iTimeSeries, Stroke stroke, String string4) {
        this(string, color, string2, string3, iSimulationVariable, iTimeSeries, stroke, false, string4);
    }

    public ControlGraphSeries(String string, Color color, String string2, String string3, ISimulationVariable iSimulationVariable, ITimeSeries iTimeSeries, Stroke stroke, boolean bl, String string4) {
        this.units = string3;
        this.editable = bl;
        this.stroke = stroke;
        this.title = string;
        this.color = color;
        this.abbr = string2;
        this.simulationVariable = iSimulationVariable;
        this.observableTimeSeries = iTimeSeries;
        this.character = string4;
        if (!$assertionsDisabled && string4 == null) {
            throw new AssertionError();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public Color getColor() {
        return this.color;
    }

    public String getAbbr() {
        return this.abbr;
    }

    public ISimulationVariable getSimulationVariable() {
        return this.simulationVariable;
    }

    public ITimeSeries getObservableTimeSeries() {
        return this.observableTimeSeries;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            this.notifyVisibilityChanged();
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String string) {
        if (!this.units.equals(string)) {
            this.units = string;
            this.notifyUnitsChanged();
        }
    }

    private void notifyUnitsChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.unitsChanged();
        }
    }

    public String getCharacterName() {
        return this.character;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void notifyVisibilityChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).visibilityChanged();
        }
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    static {
        $assertionsDisabled = !ControlGraphSeries.class.desiredAssertionStatus();
    }

    public static class Adapter
    implements Listener {
        public void visibilityChanged() {
        }

        public void unitsChanged() {
        }
    }

    public static interface Listener {
        public void visibilityChanged();

        public void unitsChanged();
    }
}

