/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.graphs;

import edu.colorado.phet.common.motion.graphs.ControlGraphSeries;
import edu.colorado.phet.common.motion.graphs.GraphControlTextBox;
import edu.colorado.phet.common.piccolophet.nodes.ShadowPText;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Font;

public class GraphControlSeriesNode
extends PNode {
    private ShadowPText shadowPText;
    private PSwing textBox;
    private GraphControlTextBox boxGraphControl;
    public static final Font LABEL_FONT = new Font("Lucida Sans", 1, 14);

    public GraphControlSeriesNode(ControlGraphSeries controlGraphSeries) {
        this.shadowPText = new ShadowPText(controlGraphSeries.getTitle());
        this.shadowPText.setFont(LABEL_FONT);
        this.shadowPText.setTextPaint(controlGraphSeries.getColor());
        this.shadowPText.setShadowColor(Color.black);
        this.addChild(this.shadowPText);
        this.boxGraphControl = this.createGraphControlTextBox(controlGraphSeries);
        this.textBox = new PSwing(this.boxGraphControl);
        this.addChild(this.textBox);
    }

    protected GraphControlTextBox createGraphControlTextBox(ControlGraphSeries controlGraphSeries) {
        return new GraphControlTextBox(controlGraphSeries);
    }

    public void relayout(double d) {
        this.shadowPText.setOffset(0.0, 0.0);
        this.textBox.setOffset(0.0, this.shadowPText.getFullBounds().getMaxY() + d);
    }

    public void setEditable(boolean bl) {
        this.boxGraphControl.setEditable(bl);
    }

    public GraphControlTextBox getTextBox() {
        return this.boxGraphControl;
    }
}

