/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.graphs;

import edu.colorado.phet.common.motion.graphs.ControlGraphSeries;
import edu.colorado.phet.common.motion.graphs.ShadowJLabel;
import edu.colorado.phet.common.motion.model.ISimulationVariable;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GraphControlTextBox
extends JPanel {
    private JTextField textField;
    private DecimalFormat decimalFormat = new DefaultDecimalFormat("0.00");
    private ControlGraphSeries series;

    public GraphControlTextBox(ControlGraphSeries controlGraphSeries) {
        this.series = controlGraphSeries;
        Font font = new Font("Lucida Sans", 0, 18);
        this.add(new ShadowJLabel(controlGraphSeries.getAbbr(), controlGraphSeries.getColor(), font));
        JLabel jLabel = new JLabel(" =");
        jLabel.setBackground(Color.white);
        jLabel.setFont(font);
        this.add(jLabel);
        this.textField = new JTextField("0.0", 6);
        this.textField.setHorizontalAlignment(4);
        this.add(this.textField);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        controlGraphSeries.getSimulationVariable().addListener(new ISimulationVariable.Listener(){

            public void valueChanged() {
                GraphControlTextBox.this.update();
            }
        });
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphControlTextBox.this.setSimValueFromTextField();
            }
        });
        this.textField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                GraphControlTextBox.this.setSimValueFromTextField();
            }

            public void focusGained(FocusEvent focusEvent) {
                GraphControlTextBox.this.textField.setSelectionStart(0);
                GraphControlTextBox.this.textField.setSelectionEnd(GraphControlTextBox.this.textField.getText().length());
            }
        });
        this.update();
    }

    protected void setSimValueFromTextField() {
        this.series.getSimulationVariable().setValue(this.getModelValue());
    }

    protected double getModelValue() {
        return this.getTextFieldValue();
    }

    protected double getTextFieldValue() {
        return Double.parseDouble(this.textField.getText());
    }

    protected void update() {
        this.textField.setText(this.decimalFormat.format(this.getDisplayValue()));
    }

    protected double getDisplayValue() {
        return this.getSimVarValue();
    }

    protected double getSimVarValue() {
        return this.series.getSimulationVariable().getData().getValue();
    }

    public void setEditable(boolean bl) {
        this.textField.setEditable(bl);
    }

    public JTextField getTextField() {
        return this.textField;
    }
}

