/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.graphs;

import edu.colorado.phet.common.jfreechartphet.piccolo.JFreeChartCursorNode;
import edu.colorado.phet.common.motion.graphs.ControlGraph;
import edu.colorado.phet.common.motion.graphs.IUpdateStrategy;
import edu.colorado.phet.common.motion.model.ISimulationVariable;
import edu.colorado.phet.common.motion.model.MotionModel;
import edu.colorado.phet.common.motion.model.UpdateStrategy;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.ZoomControlNode;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.umd.cs.piccolo.PNode;
import java.util.ArrayList;

public class MotionControlGraph
extends ControlGraph {
    private ArrayList listeners = new ArrayList();
    private MotionModel motionModel;
    private JFreeChartCursorNode jFreeChartCursorNode;
    private IUpdateStrategy iPositionDriven;
    private UpdateStrategy updateStrategy;

    public MotionControlGraph(PhetPCanvas phetPCanvas, ISimulationVariable iSimulationVariable, String string, String string2, double d, double d2, PNode pNode, final MotionModel motionModel, boolean bl, final TimeSeriesModel timeSeriesModel, UpdateStrategy updateStrategy, double d3, IUpdateStrategy iUpdateStrategy) {
        super(phetPCanvas, iSimulationVariable, string2, d, d2, pNode, timeSeriesModel, d3);
        this.iPositionDriven = iUpdateStrategy;
        this.motionModel = motionModel;
        this.updateStrategy = updateStrategy;
        this.addHorizontalZoomListener(new ZoomControlNode.ZoomListener(){

            public void zoomedOut() {
                MotionControlGraph.this.notifyZoomChanged();
            }

            public void zoomedIn() {
                MotionControlGraph.this.notifyZoomChanged();
            }
        });
        this.setEditable(bl);
        this.jFreeChartCursorNode = new JFreeChartCursorNode(this.getJFreeChartNode());
        this.addChild(this.jFreeChartCursorNode);
        timeSeriesModel.addPlaybackTimeChangeListener(new TimeSeriesModel.PlaybackTimeListener(){

            public void timeChanged() {
                MotionControlGraph.this.jFreeChartCursorNode.setTime(timeSeriesModel.getTime());
            }
        });
        this.jFreeChartCursorNode.addListener(new JFreeChartCursorNode.Listener(){

            public void cursorTimeChanged() {
                timeSeriesModel.setPlaybackTime(MotionControlGraph.this.jFreeChartCursorNode.getTime());
            }
        });
        motionModel.getTimeSeriesModel().addListener(new TimeSeriesModel.Adapter(){

            public void modeChanged() {
                MotionControlGraph.this.updateCursorVisible();
            }

            public void pauseChanged() {
                MotionControlGraph.this.updateCursorLocation();
                MotionControlGraph.this.updateCursorVisible();
            }
        });
        this.jFreeChartCursorNode.addListener(new JFreeChartCursorNode.Listener(){

            public void cursorTimeChanged() {
                motionModel.getTimeSeriesModel().setPlaybackMode();
                motionModel.getTimeSeriesModel().setPlaybackTime(MotionControlGraph.this.jFreeChartCursorNode.getTime());
            }
        });
        motionModel.getTimeSeriesModel().addListener(new TimeSeriesModel.Adapter(){

            public void dataSeriesChanged() {
                MotionControlGraph.this.jFreeChartCursorNode.setMaxDragTime(motionModel.getTimeSeriesModel().getRecordTime());
            }

            public void dataSeriesCleared() {
                MotionControlGraph.this.clear();
                MotionControlGraph.this.getDynamicJFreeChartNode().forceUpdateAll();
            }
        });
        this.updateCursorVisible();
        this.addListener(new ControlGraph.Adapter(){

            public void controlFocusGrabbed() {
                MotionControlGraph.this.handleControlFocusGrabbed();
            }
        });
    }

    protected void handleControlFocusGrabbed() {
        super.handleControlFocusGrabbed();
        if (this.updateStrategy != null) {
            this.iPositionDriven.setUpdateStrategy(this.updateStrategy);
        }
    }

    private void updateCursorLocation() {
        this.jFreeChartCursorNode.setTime(this.motionModel.getTimeSeriesModel().getTime());
    }

    private void updateCursorVisible() {
        this.jFreeChartCursorNode.setVisible(this.motionModel.getTimeSeriesModel().isPlaybackMode() || this.motionModel.getTimeSeriesModel().isPaused());
    }

    public boolean hasListener(Listener listener) {
        return this.listeners.contains(listener);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyZoomChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).horizontalZoomChanged(this);
        }
    }

    public static interface Listener {
        public void horizontalZoomChanged(MotionControlGraph var1);
    }
}

