/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.graphs;

import edu.colorado.phet.common.motion.graphs.ControlGraphSeries;
import edu.colorado.phet.common.motion.model.ISimulationVariable;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.ShadowHTMLNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.text.DecimalFormat;

public class ReadoutTitleNode
extends PNode {
    private ShadowHTMLNode titlePText;
    private ControlGraphSeries series;
    private DecimalFormat decimalFormat = new DefaultDecimalFormat("0.00");
    private PhetPPath background;

    public ReadoutTitleNode(ControlGraphSeries controlGraphSeries) {
        this.series = controlGraphSeries;
        this.titlePText = new ShadowHTMLNode();
        this.titlePText.setFont(this.getTitleFont());
        this.titlePText.setColor(controlGraphSeries.getColor());
        this.background = new PhetPPath(Color.white);
        this.addChild(this.background);
        this.addChild(this.titlePText);
        controlGraphSeries.getSimulationVariable().addListener(new ISimulationVariable.Listener(){

            public void valueChanged() {
                ReadoutTitleNode.this.updateText();
            }
        });
        controlGraphSeries.addListener(new ControlGraphSeries.Adapter(){

            public void unitsChanged() {
                ReadoutTitleNode.this.updateText();
            }
        });
        this.updateText();
    }

    private Font getTitleFont() {
        if (Toolkit.getDefaultToolkit().getScreenSize().width <= 1024) {
            return new Font("Lucida Sans", 1, 11);
        }
        return new Font("Lucida Sans", 1, 14);
    }

    public ControlGraphSeries getSeries() {
        return this.series;
    }

    protected void updateText() {
        String string = this.decimalFormat.format(this.getValueToDisplay());
        this.titlePText.setHtml("<html>" + this.series.getAbbr() + "<sub>" + this.series.getCharacterName() + "</sub>=" + string + " " + this.series.getUnits());
        this.background.setPathTo(RectangleUtils.expand(this.titlePText.getFullBounds(), 2.0, 2.0));
    }

    protected double getValueToDisplay() {
        return this.series.getSimulationVariable().getValue();
    }
}

