/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import edu.colorado.phet.common.motion.model.ITimeSeries;
import edu.colorado.phet.common.motion.model.TimeData;
import java.util.ArrayList;
import java.util.List;

public class DefaultTimeSeries
implements ITimeSeries {
    private ArrayList data = new ArrayList();
    private ArrayList listeners = new ArrayList();

    public TimeData getData() {
        return this.getRecentData(0);
    }

    public TimeData getData(int n) {
        return (TimeData)this.data.get(n);
    }

    public TimeData getRecentData(int n) {
        return this.getData(this.data.size() - 1 - n);
    }

    public int getSampleCount() {
        return this.data.size();
    }

    public void clear() {
        if (this.data.size() > 0) {
            this.data.clear();
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ITimeSeries.Listener)this.listeners.get(i)).dataCleared();
            }
        }
    }

    public double getValue() {
        return this.getRecentData(0).getValue();
    }

    public void addValue(double d, double d2) {
        TimeData timeData = new TimeData(d, d2);
        this.data.add(timeData);
        this.notifyObservers(timeData);
    }

    private void notifyObservers(TimeData timeData) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ITimeSeries.Listener listener = (ITimeSeries.Listener)this.listeners.get(i);
            listener.dataAdded(timeData);
        }
    }

    public double getTime() {
        return this.getRecentData(0).getTime();
    }

    public void addListener(ITimeSeries.Listener listener) {
        this.listeners.add(listener);
    }

    public TimeData[] getRecentSeries(int n) {
        List list = this.data.subList(this.data.size() - n, this.data.size());
        return list.toArray(new TimeData[0]);
    }

    public double getValueForTime(double d) {
        return this.getDataForTime(d).getValue();
    }

    private TimeData getDataForTime(double d) {
        TimeData timeData = this.getData();
        for (int i = 0; i < this.getSampleCount(); ++i) {
            if (!(Math.abs(this.getData(i).getTime() - d) < Math.abs(timeData.getTime() - d))) continue;
            timeData = this.getData(i);
        }
        return timeData;
    }

    public static void verifySeriesCleared() {
    }
}

