/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import edu.colorado.phet.common.motion.graphs.IUpdateStrategy;
import edu.colorado.phet.common.motion.model.AccelerationDriven;
import edu.colorado.phet.common.motion.model.DefaultSimulationVariable;
import edu.colorado.phet.common.motion.model.ISimulationVariable;
import edu.colorado.phet.common.motion.model.ITimeSeries;
import edu.colorado.phet.common.motion.model.MotionBodySeries;
import edu.colorado.phet.common.motion.model.MotionBodyState;
import edu.colorado.phet.common.motion.model.PositionDriven;
import edu.colorado.phet.common.motion.model.UpdateStrategy;
import edu.colorado.phet.common.motion.model.VelocityDriven;

public class MotionBody
implements IUpdateStrategy {
    private MotionBodySeries motionBodySeries = new MotionBodySeries();
    private MotionBodyState motionBodyState = new MotionBodyState();
    private DefaultSimulationVariable x = new DefaultSimulationVariable();
    private DefaultSimulationVariable v;
    private DefaultSimulationVariable a;

    public MotionBody() {
        this.motionBodyState.addListener(new MotionBodyState.Adapter(){

            public void positionChanged(double d) {
                MotionBody.this.x.setValue(MotionBody.this.motionBodyState.getPosition());
            }
        });
        this.x.addListener(new ISimulationVariable.Listener(){

            public void valueChanged() {
                MotionBody.this.motionBodyState.setPosition(MotionBody.this.x.getValue());
            }
        });
        this.v = new DefaultSimulationVariable();
        this.motionBodyState.addListener(new MotionBodyState.Adapter(){

            public void velocityChanged() {
                MotionBody.this.v.setValue(MotionBody.this.motionBodyState.getVelocity());
            }
        });
        this.v.addListener(new ISimulationVariable.Listener(){

            public void valueChanged() {
                MotionBody.this.motionBodyState.setVelocity(MotionBody.this.v.getValue());
            }
        });
        this.a = new DefaultSimulationVariable();
        this.motionBodyState.addListener(new MotionBodyState.Adapter(){

            public void accelerationChanged() {
                MotionBody.this.a.setValue(MotionBody.this.motionBodyState.getAcceleration());
            }
        });
        this.a.addListener(new ISimulationVariable.Listener(){

            public void valueChanged() {
                MotionBody.this.motionBodyState.setAcceleration(MotionBody.this.a.getValue());
            }
        });
    }

    public MotionBodySeries getMotionBodySeries() {
        return this.motionBodySeries;
    }

    public MotionBodyState getMotionBodyState() {
        return this.motionBodyState;
    }

    public void setTime(double d) {
        this.motionBodyState.setPosition(this.motionBodySeries.getXTimeSeries().getValueForTime(d));
        this.motionBodyState.setVelocity(this.motionBodySeries.getVTimeSeries().getValueForTime(d));
        this.motionBodyState.setAcceleration(this.motionBodySeries.getATimeSeries().getValueForTime(d));
    }

    public void stepInTime(double d, double d2) {
        this.motionBodySeries.stepInTime(d, this.motionBodyState, d2);
        this.updateStateFromSeries();
    }

    public void updateStateFromSeries() {
        this.motionBodyState.setPosition(this.motionBodySeries.getXTimeSeries().getValue());
        this.motionBodyState.setVelocity(this.motionBodySeries.getVTimeSeries().getValue());
        this.motionBodyState.setAcceleration(this.motionBodySeries.getATimeSeries().getValue());
    }

    public void clear() {
        this.motionBodySeries.clear();
    }

    public ISimulationVariable getXVariable() {
        return this.x;
    }

    public double getAcceleration() {
        return this.motionBodyState.getAcceleration();
    }

    public double getVelocity() {
        return this.motionBodyState.getVelocity();
    }

    public double getPosition() {
        return this.motionBodyState.getPosition();
    }

    public void setPosition(double d) {
        this.motionBodyState.setPosition(d);
    }

    public ISimulationVariable getVVariable() {
        return this.v;
    }

    public ISimulationVariable getAVariable() {
        return this.a;
    }

    public PositionDriven getPositionDriven() {
        return this.motionBodySeries.getPositionDriven();
    }

    public ITimeSeries getXTimeSeries() {
        return this.motionBodySeries.getXTimeSeries();
    }

    public void setPositionDriven() {
        this.motionBodySeries.setPositionDriven();
    }

    public void setUpdateStrategy(UpdateStrategy updateStrategy) {
        this.motionBodySeries.setUpdateStrategy(updateStrategy);
    }

    public ITimeSeries getVTimeSeries() {
        return this.motionBodySeries.getVTimeSeries();
    }

    public ITimeSeries getATimeSeries() {
        return this.motionBodySeries.getATimeSeries();
    }

    public VelocityDriven getVelocityDriven() {
        return this.motionBodySeries.getVelocityDriven();
    }

    public AccelerationDriven getAccelDriven() {
        return this.motionBodySeries.getAccelDriven();
    }

    public void reset() {
        this.clear();
        this.getXVariable().setValue(0.0);
        this.getVVariable().setValue(0.0);
        this.getAVariable().setValue(0.0);
    }
}

