/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import edu.colorado.phet.common.motion.model.AccelerationDriven;
import edu.colorado.phet.common.motion.model.DefaultTimeSeries;
import edu.colorado.phet.common.motion.model.MotionBodyState;
import edu.colorado.phet.common.motion.model.PositionDriven;
import edu.colorado.phet.common.motion.model.TimeData;
import edu.colorado.phet.common.motion.model.UpdateStrategy;
import edu.colorado.phet.common.motion.model.VelocityDriven;

public class MotionBodySeries {
    private DefaultTimeSeries positionTimeSeries = new DefaultTimeSeries();
    private DefaultTimeSeries velocityTimeSeries = new DefaultTimeSeries();
    private DefaultTimeSeries accelerationTimeSeries = new DefaultTimeSeries();
    private PositionDriven positionDriven = new PositionDriven();
    private VelocityDriven velocityDriven = new VelocityDriven();
    private AccelerationDriven accelDriven = new AccelerationDriven();
    private UpdateStrategy updateStrategy = this.positionDriven;

    public DefaultTimeSeries getXTimeSeries() {
        return this.positionTimeSeries;
    }

    public DefaultTimeSeries getVTimeSeries() {
        return this.velocityTimeSeries;
    }

    public DefaultTimeSeries getATimeSeries() {
        return this.accelerationTimeSeries;
    }

    public void addPositionData(double d, double d2) {
        this.positionTimeSeries.addValue(d, d2);
    }

    public void addVelocityData(double d, double d2) {
        this.velocityTimeSeries.addValue(d, d2);
    }

    public void addAccelerationData(double d, double d2) {
        this.accelerationTimeSeries.addValue(d, d2);
    }

    public TimeData[] getRecentVelocityTimeSeries(int n) {
        return this.velocityTimeSeries.getRecentSeries(n);
    }

    public TimeData[] getRecentPositionTimeSeries(int n) {
        return this.positionTimeSeries.getRecentSeries(n);
    }

    public int getAccelerationSampleCount() {
        return this.accelerationTimeSeries.getSampleCount();
    }

    public int getVelocitySampleCount() {
        return this.velocityTimeSeries.getSampleCount();
    }

    public int getPositionSampleCount() {
        return this.positionTimeSeries.getSampleCount();
    }

    public void clear() {
        this.positionTimeSeries.clear();
        this.velocityTimeSeries.clear();
        this.accelerationTimeSeries.clear();
    }

    public PositionDriven getPositionDriven() {
        return this.positionDriven;
    }

    public VelocityDriven getVelocityDriven() {
        return this.velocityDriven;
    }

    public AccelerationDriven getAccelDriven() {
        return this.accelDriven;
    }

    public void setUpdateStrategy(UpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public void setPositionDriven() {
        this.setUpdateStrategy(this.positionDriven);
    }

    public void stepInTime(double d, MotionBodyState motionBodyState, double d2) {
        this.updateStrategy.update(this, d2, motionBodyState, d);
    }
}

