/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import java.io.Serializable;
import java.util.ArrayList;

public class MotionBodyState
implements Serializable {
    private transient ArrayList listeners = new ArrayList();
    private double position;
    private double velocity = 0.0;
    private double acceleration = 0.0;

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public double getPosition() {
        return this.position;
    }

    public void setPosition(double d) {
        double d2 = this.position;
        if (this.position != d) {
            this.position = d;
            this.notifyPositionChanged(d - d2);
        }
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public double getAcceleration() {
        return this.acceleration;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public void setVelocity(double d) {
        if (this.velocity != d) {
            this.velocity = d;
            this.notifyVelocityChanged();
        }
    }

    private void notifyVelocityChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).velocityChanged();
        }
    }

    public void setAcceleration(double d) {
        if (this.acceleration != d) {
            this.acceleration = d;
            this.notifyAccelerationChanged();
        }
    }

    private void notifyAccelerationChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).accelerationChanged();
        }
    }

    public void notifyPositionChanged(double d) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.positionChanged(d);
        }
    }

    public String toString() {
        return "motion body: x=" + this.position + ", v=" + this.velocity + ", a=" + this.acceleration;
    }

    public static class Adapter
    implements Listener {
        public void positionChanged(double d) {
        }

        public void velocityChanged() {
        }

        public void accelerationChanged() {
        }
    }

    public static interface Listener {
        public void positionChanged(double var1);

        public void velocityChanged();

        public void accelerationChanged();
    }
}

