/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import edu.colorado.phet.common.motion.model.DefaultTimeSeries;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.timeseries.model.RecordableModel;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.colorado.phet.common.timeseries.model.TimeState;

public class MotionModel {
    private TimeSeriesModel timeSeriesModel;
    private double time = 0.0;
    private DefaultTimeSeries timeTimeSeries = new DefaultTimeSeries();

    public MotionModel(ConstantDtClock constantDtClock) {
        RecordableModel recordableModel = new RecordableModel(){

            public void stepInTime(double d) {
                MotionModel.this.stepInTime(d);
            }

            public Object getState() {
                return new Double(MotionModel.this.time);
            }

            public void setState(Object object) {
                MotionModel.this.setTime((Double)object);
            }

            public void clear() {
                MotionModel.this.clear();
            }
        };
        this.timeSeriesModel = new TimeSeriesModel(recordableModel, constantDtClock){

            public void rewind() {
                this.setPlaybackMode();
                super.rewind();
            }
        };
        this.timeSeriesModel.addListener(new TimeSeriesModel.Adapter(){

            public void modeChanged() {
                TimeState timeState;
                if (MotionModel.this.timeSeriesModel.isRecordMode() && (timeState = MotionModel.this.timeSeriesModel.getSeries().getLastPoint()) != null) {
                    Object object = timeState.getValue();
                    MotionModel.this.setTime((Double)object);
                }
            }
        });
        this.timeSeriesModel.setRecordMode();
        constantDtClock.addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                MotionModel.this.timeSeriesModel.stepMode(clockEvent.getSimulationTimeChange());
            }
        });
    }

    protected void setTime(double d) {
        this.time = d;
    }

    public void stepInTime(double d) {
        this.time += d;
        this.timeTimeSeries.addValue(this.time, this.time);
    }

    public void clear() {
        this.time = 0.0;
        this.timeSeriesModel.clear();
        this.timeTimeSeries.clear();
    }

    public double getTime() {
        return this.time;
    }

    public TimeSeriesModel getTimeSeriesModel() {
        return this.timeSeriesModel;
    }

    public void resetAll() {
        this.clear();
    }
}

