/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import edu.colorado.phet.common.motion.MotionMath;
import edu.colorado.phet.common.motion.model.MotionBodySeries;
import edu.colorado.phet.common.motion.model.MotionBodyState;
import edu.colorado.phet.common.motion.model.TimeData;
import edu.colorado.phet.common.motion.model.UpdateStrategy;

public class PositionDriven
implements UpdateStrategy {
    private int velocityWindow = 6;
    private int accelerationWindow = 6;

    public void update(MotionBodySeries motionBodySeries, double d, MotionBodyState motionBodyState, double d2) {
        TimeData timeData = MotionMath.getDerivative(MotionMath.smooth(motionBodySeries.getRecentPositionTimeSeries(Math.min(this.velocityWindow, motionBodySeries.getPositionSampleCount())), 1));
        TimeData timeData2 = MotionMath.getDerivative(MotionMath.smooth(motionBodySeries.getRecentVelocityTimeSeries(Math.min(this.accelerationWindow, motionBodySeries.getVelocitySampleCount())), 1));
        motionBodySeries.addPositionData(motionBodyState.getPosition(), d2);
        motionBodySeries.addVelocityData(timeData.getValue(), timeData.getTime());
        motionBodySeries.addAccelerationData(timeData2.getValue(), timeData2.getTime());
    }
}

