/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import edu.colorado.phet.common.motion.MotionMath;
import edu.colorado.phet.common.motion.model.MotionBodySeries;
import edu.colorado.phet.common.motion.model.MotionBodyState;
import edu.colorado.phet.common.motion.model.TimeData;
import edu.colorado.phet.common.motion.model.UpdateStrategy;

public class VelocityDriven
implements UpdateStrategy {
    int velWindow = 10;

    public void update(MotionBodySeries motionBodySeries, double d, MotionBodyState motionBodyState, double d2) {
        double d3 = motionBodyState.getPosition() + motionBodyState.getVelocity() * d;
        TimeData timeData = MotionMath.getDerivative(motionBodySeries.getRecentVelocityTimeSeries(Math.min(this.velWindow, motionBodySeries.getAccelerationSampleCount())));
        motionBodySeries.addPositionData(d3, d2);
        motionBodySeries.addVelocityData(motionBodyState.getVelocity(), d2);
        motionBodySeries.addAccelerationData(timeData.getValue(), timeData.getTime() + d);
    }
}

