/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;

public class AWTSplashWindow
extends Window {
    private static Color defaultBackground = Color.white;
    private boolean done = false;
    private Panel panel;
    private AnimationComponent animationComponent;
    private Label textComponent;

    public AWTSplashWindow(Frame frame, String string) {
        super(frame);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                AWTSplashWindow.this.hide();
            }
        });
        this.setCursor(Cursor.getPredefinedCursor(3));
        String string2 = PhetCommonResources.getInstance().getLocalizedString("PhetApplication.StartupDialog.message");
        String string3 = MessageFormat.format(string2, string);
        BufferedImage bufferedImage = AWTSplashWindow.getLogoImage();
        ImageComponent imageComponent = new ImageComponent(bufferedImage){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                AWTSplashWindow.drawBorder(this, graphics);
            }
        };
        this.textComponent = new Label(string3);
        this.animationComponent = new AnimationComponent();
        this.panel = new Panel(new GridBagLayout()){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                AWTSplashWindow.drawBorder(this, graphics);
            }

            public void update(Graphics graphics) {
                if (graphics != null) {
                    this.paint(graphics);
                }
            }
        };
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 20, 0, 10), 0, 0);
        this.add(this.panel);
        gridBagConstraints.gridheight = 2;
        this.panel.add((Component)imageComponent, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(20, 10, 10, 20);
        this.panel.add((Component)this.textComponent, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 20, 20);
        this.panel.add((Component)this.animationComponent, gridBagConstraints);
        this.startPaintThread(this.panel);
        this.setBackground(defaultBackground);
        this.invalidate();
        this.pack();
        SwingUtils.centerWindowOnScreen(this);
    }

    private static BufferedImage getLogoImage() {
        return PhetCommonResources.getInstance().getImage("logos/phet-logo-120x50.jpg");
    }

    public void hide() {
        super.hide();
        this.done = true;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.panel.setBackground(color);
        this.textComponent.setBackground(color);
    }

    private void startPaintThread(final Component component) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                while (!AWTSplashWindow.this.done) {
                    try {
                        Thread.sleep(30L);
                        component.invalidate();
                        component.repaint();
                        component.update(component.getGraphics());
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        });
        thread.start();
    }

    private static void drawBorder(Component component, Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, component.getWidth() - 1, component.getHeight() - 1);
    }

    private static class ImageComponent
    extends Component {
        Image image;

        public ImageComponent(Image image) {
            this.image = image;
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.drawImage(this.image, 0, 0, this);
        }
    }

    private static class AnimationComponent
    extends Component {
        private static final Color BLOCK_COLOR = Color.BLACK;
        private static final Color TRACK_COLOR = Color.LIGHT_GRAY;

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            return new Dimension(250, 14);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            if (graphics == null) {
                return;
            }
            graphics.setColor(TRACK_COLOR);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(BLOCK_COLOR);
            double d = 1.5707963267948966;
            int n = (int)(Math.sin((double)System.currentTimeMillis() / 1000.0 * d) * (double)this.getWidth() / 2.0 + (double)this.getWidth() / 2.0);
            int n2 = n - 10;
            graphics.fillRect(n2, 0, 20, 14);
            graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }
}

