/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.ClockControlPanel;
import edu.colorado.phet.common.phetcommon.view.HelpPanel;
import edu.colorado.phet.common.phetcommon.view.LogoPanel;
import edu.colorado.phet.common.phetcommon.view.ModulePanel;
import javax.swing.JComponent;

public abstract class Module {
    private String name;
    private BaseModel model;
    private IClock clock;
    private boolean active = false;
    private boolean clockRunningWhenActive = true;
    private ClockAdapter moduleRunner;
    private ModulePanel modulePanel;

    protected Module() {
    }

    public Module(String string, IClock iClock, boolean bl) {
        this.name = string;
        this.clock = iClock;
        this.setModel(new BaseModel());
        this.modulePanel = new ModulePanel();
        this.setClockControlPanel(new ClockControlPanel(iClock));
        this.setLogoPanel(new LogoPanel());
        this.setHelpPanel(new HelpPanel(this));
        this.moduleRunner = new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                Module.this.handleClockTick(clockEvent);
            }
        };
        iClock.addClockListener(this.moduleRunner);
        this.clockRunningWhenActive = !bl;
    }

    public IClock getClock() {
        return this.clock;
    }

    protected void handleClockTick(ClockEvent clockEvent) {
        this.handleUserInput();
        this.model.update(clockEvent);
        this.updateGraphics(clockEvent);
    }

    public void setModel(BaseModel baseModel) {
        this.model = baseModel;
    }

    public BaseModel getModel() {
        return this.model;
    }

    public ModulePanel getModulePanel() {
        return this.modulePanel;
    }

    protected void setSimulationPanel(JComponent jComponent) {
        this.modulePanel.setSimulationPanel(jComponent);
    }

    public JComponent getSimulationPanel() {
        return this.modulePanel.getSimulationPanel();
    }

    protected void setClockControlPanel(JComponent jComponent) {
        this.modulePanel.setClockControlPanel(jComponent);
    }

    protected void setLogoPanel(JComponent jComponent) {
        this.modulePanel.setLogoPanel(jComponent);
    }

    protected void setHelpPanel(JComponent jComponent) {
        this.modulePanel.setHelpPanel(jComponent);
    }

    public HelpPanel getHelpPanel() {
        HelpPanel helpPanel = null;
        JComponent jComponent = this.modulePanel.getHelpPanel();
        if (jComponent != null && jComponent instanceof HelpPanel) {
            helpPanel = (HelpPanel)jComponent;
        }
        return helpPanel;
    }

    public boolean hasHelp() {
        return false;
    }

    public boolean hasMegaHelp() {
        return false;
    }

    public void setHelpEnabled(boolean bl) {
        HelpPanel helpPanel = this.getHelpPanel();
        if (helpPanel != null) {
            helpPanel.setHelpEnabled(bl);
        }
    }

    public boolean isHelpEnabled() {
        boolean bl = false;
        HelpPanel helpPanel = this.getHelpPanel();
        if (helpPanel != null) {
            bl = helpPanel.isHelpEnabled();
        }
        return bl;
    }

    public void showMegaHelp() {
    }

    public void setLogoPanelVisible(boolean bl) {
        JComponent jComponent = this.modulePanel.getLogoPanel();
        if (jComponent != null) {
            jComponent.setVisible(bl);
        }
    }

    public boolean isLogoPanelVisible() {
        boolean bl = false;
        JComponent jComponent = this.modulePanel.getLogoPanel();
        if (jComponent != null) {
            bl = jComponent.isVisible();
        }
        return bl;
    }

    public void activate() {
        HelpPanel helpPanel;
        if (!this.isWellFormed()) {
            throw new RuntimeException("Module missing important data, module=" + this);
        }
        if (this.clockRunningWhenActive) {
            this.clock.start();
        }
        if ((helpPanel = this.getHelpPanel()) != null) {
            helpPanel.setVisible(this.hasHelp());
        }
        this.active = true;
    }

    public void deactivate() {
        this.clockRunningWhenActive = this.getClock().isRunning();
        this.clock.pause();
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isWellFormed() {
        boolean bl = true;
        bl &= this.getModel() != null;
        return bl &= this.getSimulationPanel() != null;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "name=" + this.name + ", model=" + this.model + ", simulationPanel=" + this.getSimulationPanel();
    }

    public void setReferenceSize() {
    }

    protected void handleUserInput() {
    }

    public void updateGraphics(ClockEvent clockEvent) {
    }
}

