/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.ModuleEvent;
import edu.colorado.phet.common.phetcommon.application.ModuleObserver;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import java.util.ArrayList;

class ModuleManager {
    private ArrayList modules = new ArrayList();
    private Module activeModule;
    private PhetApplication phetApplication;
    private ArrayList moduleObservers = new ArrayList();

    ModuleManager(PhetApplication phetApplication) {
        this.phetApplication = phetApplication;
    }

    Module moduleAt(int n) {
        return (Module)this.modules.get(n);
    }

    Module getActiveModule() {
        return this.activeModule;
    }

    int numModules() {
        return this.modules.size();
    }

    void addModule(Module module) {
        this.modules.add(module);
        this.notifyModuleAdded(new ModuleEvent(this.getPhetApplication(), module));
    }

    int indexOf(Module module) {
        return this.modules.indexOf(module);
    }

    void setActiveModule(int n) {
        this.setActiveModule(this.moduleAt(n));
    }

    void setActiveModule(Module module) {
        if (module == null) {
            throw new RuntimeException("Active module can't be null.");
        }
        if (this.activeModule != module) {
            this.deactivateCurrentModule();
            this.activate(module);
            this.notifyActiveModuleChanged(new ModuleEvent(this.getPhetApplication(), module));
            this.verifyActiveState();
        }
    }

    private void verifyActiveState() {
        int n = this.getNumActiveModules();
        int n2 = this.getNumClocksRunning();
        boolean bl = this.isClockShared();
        if (n != 1) {
            new IllegalStateException("multiple modules are running: active modules=" + n).printStackTrace();
        }
        if (n2 > 1) {
            new IllegalStateException("multiple clocks are running: running clocks=" + n2).printStackTrace();
        }
        if (n2 == 1 && !this.activeModule.getClock().isRunning()) {
            new IllegalStateException("a clock is running that does not belong to the active module").printStackTrace();
        }
        if (bl) {
            new IllegalStateException("Multiple modules are using the same clock instance.").printStackTrace();
        }
    }

    private boolean isClockShared() {
        for (int i = 0; i < this.modules.size(); ++i) {
            for (int j = 0; j < this.modules.size(); ++j) {
                IClock iClock;
                IClock iClock2;
                if (j == i || (iClock2 = ((Module)this.modules.get(i)).getClock()) != (iClock = ((Module)this.modules.get(j)).getClock())) continue;
                return true;
            }
        }
        return false;
    }

    private int getNumActiveModules() {
        int n = 0;
        for (int i = 0; i < this.modules.size(); ++i) {
            if (!((Module)this.modules.get(i)).isActive()) continue;
            ++n;
        }
        return n;
    }

    private int getNumClocksRunning() {
        ArrayList<IClock> arrayList = new ArrayList<IClock>();
        for (int i = 0; i < this.modules.size(); ++i) {
            IClock iClock = ((Module)this.modules.get(i)).getClock();
            if (!iClock.isRunning() || arrayList.contains(iClock)) continue;
            arrayList.add(iClock);
        }
        return arrayList.size();
    }

    void addModuleObserver(ModuleObserver moduleObserver) {
        this.moduleObservers.add(moduleObserver);
    }

    private PhetApplication getPhetApplication() {
        return this.phetApplication;
    }

    private void activate(Module module) {
        this.activeModule = module;
        if (module != null) {
            module.activate();
            this.setActiveModule(module);
        }
    }

    void deactivateCurrentModule() {
        if (this.activeModule != null) {
            this.activeModule.deactivate();
        }
    }

    private void notifyModuleAdded(ModuleEvent moduleEvent) {
        for (int i = 0; i < this.moduleObservers.size(); ++i) {
            ModuleObserver moduleObserver = (ModuleObserver)this.moduleObservers.get(i);
            moduleObserver.moduleAdded(moduleEvent);
        }
    }

    private void notifyActiveModuleChanged(ModuleEvent moduleEvent) {
        for (int i = 0; i < this.moduleObservers.size(); ++i) {
            ModuleObserver moduleObserver = (ModuleObserver)this.moduleObservers.get(i);
            moduleObserver.activeModuleChanged(moduleEvent);
        }
    }
}

