/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.application.AWTSplashWindow;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.ModuleManager;
import edu.colorado.phet.common.phetcommon.application.ModuleObserver;
import edu.colorado.phet.common.phetcommon.application.PhetAboutDialog;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.view.ITabbedModulePane;
import edu.colorado.phet.common.phetcommon.view.JTabbedModulePane;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.util.FrameSetup;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;

public class PhetApplication {
    private static PhetApplication latestInstance = null;
    private static ArrayList phetApplications = new ArrayList();
    private TabbedPaneType tabbedPaneType;
    private volatile PhetApplicationConfig applicationConfig;
    private String title;
    private String description;
    private String version;
    private PhetFrame phetFrame;
    private ModuleManager moduleManager;
    private AWTSplashWindow splashWindow;
    private Frame splashWindowOwner;
    public static final TabbedPaneType JTABBED_PANE_TYPE = new TabbedPaneType(){

        public ITabbedModulePane createTabbedPane() {
            return new JTabbedModulePane();
        }
    };

    public PhetApplication(PhetApplicationConfig phetApplicationConfig) {
        this(phetApplicationConfig.getCommandLineArgs(), phetApplicationConfig.getName(), phetApplicationConfig.getDescription(), phetApplicationConfig.getVersion().formatForTitleBar(), phetApplicationConfig.getFrameSetup());
        this.applicationConfig = phetApplicationConfig;
    }

    public PhetApplication(PhetApplicationConfig phetApplicationConfig, TabbedPaneType tabbedPaneType) {
        this(phetApplicationConfig.getCommandLineArgs(), phetApplicationConfig.getName(), phetApplicationConfig.getDescription(), phetApplicationConfig.getVersion().formatForTitleBar(), phetApplicationConfig.getFrameSetup(), tabbedPaneType);
        this.applicationConfig = phetApplicationConfig;
    }

    public PhetApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    public static PhetApplication instance() {
        return latestInstance;
    }

    public PhetApplication(String[] stringArray, String string, String string2, String string3, FrameSetup frameSetup) {
        this(stringArray, string, string2, string3, frameSetup, JTABBED_PANE_TYPE);
    }

    public PhetApplication(String[] stringArray, String string, String string2, String string3, FrameSetup frameSetup, TabbedPaneType tabbedPaneType) {
        this.showSplashWindow(string);
        this.tabbedPaneType = tabbedPaneType;
        latestInstance = this;
        phetApplications.add(this);
        this.title = string;
        this.description = string2;
        this.version = string3;
        this.moduleManager = new ModuleManager(this);
        this.phetFrame = this.createPhetFrame();
        frameSetup.initialize(this.phetFrame);
        this.parseArgs(stringArray);
    }

    protected PhetFrame createPhetFrame() {
        return new PhetFrame(this);
    }

    private void showSplashWindow(String string) {
        if (this.splashWindow == null) {
            this.splashWindowOwner = new Frame();
            this.splashWindow = new AWTSplashWindow(this.splashWindowOwner, string);
            this.splashWindow.show();
        }
    }

    private void disposeSplashWindow() {
        if (this.splashWindow != null) {
            this.splashWindow.dispose();
            this.splashWindow = null;
            this.splashWindowOwner.dispose();
            this.splashWindowOwner = null;
        }
    }

    protected void parseArgs(String[] stringArray) {
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.equals("-d")) continue;
        }
    }

    public void startApplication() {
        if (this.moduleManager.numModules() == 0) {
            throw new RuntimeException("No modules in module manager");
        }
        this.phetFrame.addWindowFocusListener(new WindowAdapter(){

            public void windowGainedFocus(WindowEvent windowEvent) {
                PhetApplication.this.disposeSplashWindow();
                PhetApplication.this.initializeModuleReferenceSizes();
                PhetApplication.this.phetFrame.removeWindowFocusListener(this);
            }
        });
        this.moduleManager.setActiveModule(this.moduleManager.moduleAt(0));
        this.phetFrame.setVisible(true);
        this.updateLogoVisibility();
    }

    protected void updateLogoVisibility() {
        for (int i = 0; i < this.moduleManager.numModules(); ++i) {
            if (!this.moduleAt(i).isLogoPanelVisible() || this.phetFrame.getTabbedModulePane() == null || !this.phetFrame.getTabbedModulePane().getLogoVisible()) continue;
            this.moduleAt(i).setLogoPanelVisible(false);
        }
    }

    private void initializeModuleReferenceSizes() {
        for (int i = 0; i < this.moduleManager.numModules(); ++i) {
            Module module = this.moduleManager.moduleAt(i);
            module.setReferenceSize();
        }
    }

    public PhetFrame getPhetFrame() {
        return this.phetFrame;
    }

    public ITabbedModulePane createTabbedPane() {
        return this.tabbedPaneType.createTabbedPane();
    }

    public void addModule(Module module) {
        this.moduleManager.addModule(module);
    }

    public Module moduleAt(int n) {
        return this.moduleManager.moduleAt(n);
    }

    public void setActiveModule(int n) {
        this.moduleManager.setActiveModule(n);
    }

    public void addModuleObserver(ModuleObserver moduleObserver) {
        this.moduleManager.addModuleObserver(moduleObserver);
    }

    public int indexOf(Module module) {
        return this.moduleManager.indexOf(module);
    }

    public int numModules() {
        return this.moduleManager.numModules();
    }

    public Module getActiveModule() {
        return this.moduleManager.getActiveModule();
    }

    public String getTitle() {
        if (this.getApplicationConfig() != null) {
            return this.getApplicationConfig().getName();
        }
        return this.title;
    }

    public String getDescription() {
        if (this.getApplicationConfig() != null) {
            return this.getApplicationConfig().getDescription();
        }
        return this.description;
    }

    public String getVersion() {
        if (this.getApplicationConfig() != null) {
            return this.getApplicationConfig().getVersion().formatForTitleBar();
        }
        return this.version;
    }

    public String getCredits() {
        String string = null;
        if (this.getApplicationConfig() != null) {
            string = this.getApplicationConfig().getCredits();
        }
        return string;
    }

    public void pause() {
        this.getActiveModule().deactivate();
    }

    public void resume() {
        this.getActiveModule().activate();
    }

    public void showAboutDialog() {
        this.createPhetAboutDialog().show();
    }

    protected PhetAboutDialog createPhetAboutDialog() {
        return new PhetAboutDialog(this);
    }

    public static abstract class TabbedPaneType {
        protected TabbedPaneType() {
        }

        public abstract ITabbedModulePane createTabbedPane();
    }
}

