/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import java.awt.geom.Point2D;

public interface AbstractVector2D {
    public AbstractVector2D getAddedInstance(AbstractVector2D var1);

    public AbstractVector2D getScaledInstance(double var1);

    public AbstractVector2D getNormalVector();

    public AbstractVector2D getNormalizedInstance();

    public double getY();

    public double getX();

    public double getMagnitude();

    public double getAngle();

    public AbstractVector2D getInstanceOfMagnitude(double var1);

    public Point2D getDestination(Point2D var1);

    public static class Double
    implements AbstractVector2D {
        private double x;
        private double y;

        protected Double() {
            this(0.0, 0.0);
        }

        protected Double(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        protected Double(Point2D point2D) {
            this(point2D.getX(), point2D.getY());
        }

        protected Double(Point2D point2D, Point2D point2D2) {
            this(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (this.getClass() != object.getClass()) {
                bl = false;
            } else {
                AbstractVector2D abstractVector2D = (AbstractVector2D)object;
                bl = this.getX() == abstractVector2D.getX() && this.getY() == abstractVector2D.getY();
            }
            return bl;
        }

        public String toString() {
            return "AbstractVector2D.Double[" + this.x + ", " + this.y + "]";
        }

        public AbstractVector2D getAddedInstance(AbstractVector2D abstractVector2D) {
            return this.getAddedInstance(abstractVector2D.getX(), abstractVector2D.getY());
        }

        public AbstractVector2D getAddedInstance(double d, double d2) {
            return new Double(this.getX() + d, this.getY() + d2);
        }

        public AbstractVector2D getScaledInstance(double d) {
            return new Double(this.getX() * d, this.getY() * d);
        }

        public AbstractVector2D getNormalVector() {
            return new Double(this.y, -this.x);
        }

        public AbstractVector2D getNormalizedInstance() {
            double d = this.getMagnitude();
            if (d == 0.0) {
                throw new RuntimeException("Cannot normalize a zero-magnitude vector.");
            }
            return new Double(this.getX() / d, this.getY() / d);
        }

        public AbstractVector2D getSubtractedInstance(double d, double d2) {
            return new Double(this.getX() - d, this.getY() - d2);
        }

        public AbstractVector2D getSubtractedInstance(AbstractVector2D abstractVector2D) {
            return this.getSubtractedInstance(abstractVector2D.getX(), abstractVector2D.getY());
        }

        public double getY() {
            return this.y;
        }

        public double getX() {
            return this.x;
        }

        public double getMagnitudeSq() {
            return this.getX() * this.getX() + this.getY() * this.getY();
        }

        public double getMagnitude() {
            return Math.sqrt(this.getMagnitudeSq());
        }

        protected void setX(double d) {
            this.x = d;
        }

        protected void setY(double d) {
            this.y = d;
        }

        public double getAngle() {
            return Math.atan2(this.y, this.x);
        }

        public AbstractVector2D getInstanceOfMagnitude(double d) {
            return this.getScaledInstance(d / this.getMagnitude());
        }

        public Point2D getDestination(Point2D point2D) {
            return new Point2D.Double(point2D.getX() + this.getX(), point2D.getY() + this.getY());
        }

        public static AbstractVector2D parseAngleAndMagnitude(double d, double d2) {
            Double double_ = new Double(Math.cos(d2), Math.sin(d2));
            return double_.getScaledInstance(d);
        }
    }
}

