/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.ModuleEvent;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.view.ITabbedModulePane;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JTabbedModulePane
extends JTabbedPane
implements ITabbedModulePane {
    private Module current;
    private PhetApplication application;

    public void init(final PhetApplication phetApplication, Module[] moduleArray) {
        this.application = phetApplication;
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = JTabbedModulePane.this.getSelectedIndex();
                if (n >= 0 && phetApplication.numModules() > 0) {
                    JTabbedModulePane.this.current = phetApplication.moduleAt(n);
                    phetApplication.setActiveModule(n);
                }
            }
        });
        phetApplication.addModuleObserver(this);
        for (int i = 0; i < moduleArray.length; ++i) {
            Module module = moduleArray[i];
            this.addTab(module);
        }
        this.setOpaque(true);
    }

    public void addTab(Module module) {
        this.addTab(module.getName(), module.getModulePanel());
    }

    public void moduleAdded(ModuleEvent moduleEvent) {
    }

    public void activeModuleChanged(ModuleEvent moduleEvent) {
        if (this.current != moduleEvent.getModule()) {
            int n;
            int n2 = this.application.indexOf(moduleEvent.getModule());
            if (n2 < (n = this.getTabCount())) {
                this.setSelectedIndex(n2);
            } else {
                throw new RuntimeException("Requested illegal tab: tab count=" + n + ", requestedIndex=" + n2);
            }
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public boolean getLogoVisible() {
        return false;
    }
}

