/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.ModuleEvent;
import edu.colorado.phet.common.phetcommon.application.ModuleObserver;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.view.ITabbedModulePane;
import edu.colorado.phet.common.phetcommon.view.ModulePanel;
import edu.colorado.phet.common.phetcommon.view.menu.HelpMenu;
import edu.colorado.phet.common.phetcommon.view.menu.PhetFileMenu;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

public class PhetFrame
extends JFrame {
    private HelpMenu helpMenu;
    private JMenu defaultFileMenu;
    private PhetApplication application;
    private Container contentPanel;
    private Module lastAdded;

    public PhetFrame(final PhetApplication phetApplication) throws HeadlessException {
        super(phetApplication.getTitle() + " (" + phetApplication.getVersion() + ")");
        this.application = phetApplication;
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            public void windowIconified(WindowEvent windowEvent) {
                phetApplication.pause();
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                phetApplication.resume();
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        this.helpMenu = new HelpMenu(phetApplication);
        this.defaultFileMenu = new PhetFileMenu();
        jMenuBar.add(this.defaultFileMenu);
        jMenuBar.add(this.helpMenu);
        this.setJMenuBar(jMenuBar);
        phetApplication.addModuleObserver(new ModuleObserver(){

            public void moduleAdded(ModuleEvent moduleEvent) {
                PhetFrame.this.addModule(moduleEvent.getModule());
            }

            public void activeModuleChanged(ModuleEvent moduleEvent) {
            }
        });
    }

    public void setContentPane(Container container) {
        super.setContentPane(container);
        this.contentPanel = container;
    }

    private void addModule(Module module) {
        this.setContentPane(this.addToContentPane(module));
        this.lastAdded = module;
    }

    private JComponent addToContentPane(Module module) {
        if (this.contentPanel == null) {
            return module.getModulePanel();
        }
        if (this.contentPanel instanceof ModulePanel) {
            ITabbedModulePane iTabbedModulePane = this.application.createTabbedPane();
            iTabbedModulePane.init(this.application, new Module[]{this.lastAdded, module});
            return iTabbedModulePane.getComponent();
        }
        if (this.contentPanel instanceof ITabbedModulePane) {
            ITabbedModulePane iTabbedModulePane = (ITabbedModulePane)((Object)this.contentPanel);
            iTabbedModulePane.addTab(module);
            return (JComponent)((Object)iTabbedModulePane);
        }
        throw new RuntimeException("Illegal type for content pane: " + this.contentPanel);
    }

    public ITabbedModulePane getTabbedModulePane() {
        if (this.contentPanel instanceof ITabbedModulePane) {
            return (ITabbedModulePane)((Object)this.contentPanel);
        }
        return null;
    }

    public void addMenu(JMenu jMenu) {
        SwingUtils.addMenuAt(jMenu, this.getJMenuBar(), this.getJMenuBar().getMenuCount() - 1);
    }

    public HelpMenu getHelpMenu() {
        return this.helpMenu;
    }
}

