/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet;

import edu.colorado.phet.common.piccolophet.PhetRootPNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import javax.swing.BorderFactory;

public class PhetPCanvas
extends PSwingCanvas {
    private TransformStrategy transformStrategy;
    private ComponentAdapter resizeAdapter;
    private PhetRootPNode phetRootNode;
    private AffineTransform transform;

    public PhetPCanvas() {
        this(new ConstantTransformStrategy(new AffineTransform()));
    }

    public PhetPCanvas(TransformStrategy transformStrategy) {
        this.transformStrategy = transformStrategy;
        this.phetRootNode = new PhetRootPNode();
        this.getLayer().addChild(this.phetRootNode);
        this.removeInputEventListener(this.getZoomEventHandler());
        this.removeInputEventListener(this.getPanEventHandler());
        this.resizeAdapter = new ResizeAdapter();
        this.addComponentListener(this.resizeAdapter);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PhetPCanvas.this.requestFocus();
            }
        });
        this.setOpaque(true);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.requestFocus();
    }

    protected void updateScale() {
        this.phetRootNode.setWorldTransform(this.transformStrategy.getWorldTransform());
    }

    public PhetRootPNode getPhetRootNode() {
        return this.phetRootNode;
    }

    public void addScreenChild(PNode pNode) {
        this.phetRootNode.addScreenChild(pNode);
    }

    public void removeScreenChild(PNode pNode) {
        this.phetRootNode.removeChild(pNode);
    }

    public void paintComponent(Graphics graphics) {
        this.transform = ((Graphics2D)graphics).getTransform();
        super.paintComponent(graphics);
    }

    public static class ConstantTransformStrategy
    implements TransformStrategy {
        private AffineTransform affineTransform;

        public ConstantTransformStrategy(AffineTransform affineTransform) {
            this.affineTransform = affineTransform;
        }

        public AffineTransform getWorldTransform() {
            return new AffineTransform(this.affineTransform);
        }
    }

    public static interface TransformStrategy {
        public AffineTransform getWorldTransform();
    }

    protected class ResizeAdapter
    extends ComponentAdapter {
        protected ResizeAdapter() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            PhetPCanvas.this.updateScale();
        }

        public void componentShown(ComponentEvent componentEvent) {
            PhetPCanvas.this.updateScale();
        }
    }
}

