/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PhetTabbedPane
extends JPanel {
    private TabPane tabPane;
    private JComponent component;
    private Color selectedTabColor;
    private ArrayList changeListeners = new ArrayList();
    private Font tabFont = new Font("Lucida Sans", 1, 16);
    private TabNodeFactory tabNodeFactory = new TabNodeFactory();
    public static final Color DEFAULT_SELECTED_TAB_COLOR = new Color(150, 150, 255);

    public PhetTabbedPane() {
        this(DEFAULT_SELECTED_TAB_COLOR);
    }

    public PhetTabbedPane(Color color) {
        super(new BorderLayout());
        this.selectedTabColor = color;
        this.component = new JPanel();
        this.tabPane = new TabPane(color);
        this.add((Component)this.tabPane, "North");
        this.setComponent(this.component);
        ComponentListener componentListener = new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                PhetTabbedPane.this.relayoutComponents();
            }

            public void componentShown(ComponentEvent componentEvent) {
                PhetTabbedPane.this.relayoutComponents();
            }
        };
        this.addComponentListener(componentListener);
    }

    public void setLogoVisible(boolean bl) {
        this.tabPane.setLogoVisible(bl);
    }

    public int getTabCount() {
        return this.tabPane.getTabCount();
    }

    private void relayoutComponents() {
        Rectangle rectangle = this.component.getBounds();
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.tabPane.getTabs()[i].getComponent().setSize(rectangle.width, rectangle.height);
            this.updateLayout(this.tabPane.getTabs()[i].getComponent());
        }
    }

    private void updateLayout(Component component) {
        component.doLayout();
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.updateLayout(container.getComponent(i));
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public int getSelectedIndex() {
        return this.tabPane.getSelectedIndex();
    }

    public void addTab(String string, JComponent jComponent) {
        AbstractTabNode abstractTabNode = this.createTab(string, jComponent);
        abstractTabNode.addInputEventListener(new TabInputListener(abstractTabNode));
        if (this.tabPane.getTabs().length == 0) {
            this.setSelectedTab(abstractTabNode);
            this.tabPane.setSelectedTab(abstractTabNode);
        } else {
            abstractTabNode.setSelected(false);
        }
        this.tabPane.addTab(abstractTabNode);
        this.relayoutComponents();
    }

    protected AbstractTabNode createTab(String string, JComponent jComponent) {
        return this.tabNodeFactory.createTabNode(string, jComponent, this.selectedTabColor, this.tabFont);
    }

    public void setSelectedIndex(int n) {
        if (n < 0 || n >= this.getTabCount()) {
            throw new RuntimeException("Illegal tab index: " + n + ", tab count=" + this.getTabCount());
        }
        this.setSelectedTab(this.tabPane.getTabs()[n]);
    }

    protected void setSelectedTab(AbstractTabNode abstractTabNode) {
        this.setComponent(abstractTabNode.getComponent());
        abstractTabNode.setSelected(true);
        for (int i = 0; i < this.tabPane.getTabs().length; ++i) {
            AbstractTabNode abstractTabNode2 = this.tabPane.getTabs()[i];
            if (abstractTabNode2 == abstractTabNode) continue;
            abstractTabNode2.setSelected(false);
        }
        this.tabPane.setSelectedTab(abstractTabNode);
        this.notifySelectionChanged();
    }

    private void notifySelectionChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)this.changeListeners.get(i);
            changeListener.stateChanged(changeEvent);
        }
    }

    private void setComponent(JComponent jComponent) {
        if (jComponent != this.component) {
            if (this.component != null) {
                this.remove(this.component);
            }
            this.component = jComponent;
            this.add((Component)jComponent, "Center");
            this.revalidate();
            this.repaint();
        }
    }

    public boolean getLogoVisible() {
        return this.tabPane.getLogoVisible();
    }

    private static int darker(int n, int n2) {
        return Math.max(0, n - n2);
    }

    private static Color darker(Color color, int n) {
        return new Color(PhetTabbedPane.darker(color.getRed(), n), PhetTabbedPane.darker(color.getGreen(), n), PhetTabbedPane.darker(color.getBlue(), n));
    }

    protected class TabInputListener
    extends PBasicInputEventHandler {
        private AbstractTabNode tab;

        public TabInputListener(AbstractTabNode abstractTabNode) {
            this.tab = abstractTabNode;
        }

        public void mouseReleased(PInputEvent pInputEvent) {
            if (this.tab.getFullBounds().contains(pInputEvent.getCanvasPosition())) {
                PhetTabbedPane.this.setSelectedTab(this.tab);
            }
        }

        public void mouseEntered(PInputEvent pInputEvent) {
            PhetTabbedPane.this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void mouseExited(PInputEvent pInputEvent) {
            PhetTabbedPane.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public static class TabPane
    extends PCanvas {
        private ArrayList tabs = new ArrayList();
        private double distBetweenTabs = -6.0;
        private TabBase tabBase;
        private int tabTopInset = 3;
        private PImage logo;
        private AbstractTabNode selectedTab;
        private boolean logoObscured = false;
        private boolean logoVisible = true;

        public TabPane(Color color) {
            BufferedImage bufferedImage = PhetCommonResources.getInstance().getImage("logos/phet-logo-120x50.jpg");
            this.logo = new PImage(bufferedImage);
            this.tabBase = new TabBase(color);
            this.setPanEventHandler(null);
            this.setZoomEventHandler(null);
            this.setOpaque(false);
            this.getLayer().addChild(this.logo);
            this.getLayer().addChild(this.tabBase);
            this.addComponentListener(new ComponentListener(this){
                private final /* synthetic */ TabPane this$0;
                {
                    this.this$0 = tabPane;
                }

                public void componentHidden(ComponentEvent componentEvent) {
                }

                public void componentMoved(ComponentEvent componentEvent) {
                }

                public void componentResized(ComponentEvent componentEvent) {
                    TabPane.access$100(this.this$0);
                }

                public void componentShown(ComponentEvent componentEvent) {
                    TabPane.access$100(this.this$0);
                }
            });
            this.relayout();
        }

        public AbstractTabNode getSelectedTab() {
            return this.selectedTab;
        }

        public void addTab(AbstractTabNode abstractTabNode) {
            this.tabs.add(abstractTabNode);
            this.getLayer().addChild(0, abstractTabNode);
            this.relayout();
            this.setSelectedTab(this.getSelectedTab() == null ? abstractTabNode : this.getSelectedTab());
        }

        private void relayout() {
            this.tabBase.setTabBaseWidth(this.getWidth());
            int n = AbstractTabNode.tabInsets.left + 10;
            double d = this.getMaxTabTextHeight();
            for (int i = 0; i < this.tabs.size(); ++i) {
                AbstractTabNode abstractTabNode = (AbstractTabNode)this.tabs.get(i);
                abstractTabNode.setOffset(n, this.tabTopInset);
                abstractTabNode.setTabTextHeight(d);
                n = (int)((double)n + (abstractTabNode.getFullBounds().getWidth() + this.distBetweenTabs));
            }
            double d2 = (double)this.getHeight() - this.tabBase.getFullBounds().getHeight();
            this.tabBase.setOffset(0.0, d2);
            this.relayoutLogo(d2);
            for (int i = 0; i < this.tabs.size(); ++i) {
                this.getTab(i).updatePaint();
            }
            this.tabBase.updatePaint();
        }

        private void relayoutLogo(double d) {
            if (this.logo.getImage().getHeight(null) > this.getHeight()) {
                double d2 = ((double)this.getHeight() - 5.0) / (double)this.logo.getImage().getHeight(null);
                this.logo.setScale(Math.max(d2, 0.5));
            } else {
                this.logo.setScale(1.0);
            }
            this.logo.setOffset((double)this.getWidth() - this.logo.getFullBounds().getWidth(), d / 2.0 - this.logo.getFullBounds().getHeight() / 2.0);
            if (this.tabs.size() > 0) {
                AbstractTabNode abstractTabNode = (AbstractTabNode)this.tabs.get(this.tabs.size() - 1);
                if (this.logo.getXOffset() < abstractTabNode.getFullBounds().getMaxX()) {
                    this.logoObscured = true;
                    this.updateLogoVisible();
                } else {
                    this.logoObscured = false;
                    this.updateLogoVisible();
                }
            }
        }

        public Dimension getPreferredSize() {
            this.relayout();
            int n = this.getMaxTabHeight();
            int n2 = (int)this.getLayer().getFullBounds().getWidth();
            n2 = Math.max(n2, super.getPreferredSize().width);
            return new Dimension(n2, (int)((double)n + this.tabBase.getFullBounds().getHeight()));
        }

        private double getMaxTabTextHeight() {
            double d = 0.0;
            for (int i = 0; i < this.tabs.size(); ++i) {
                AbstractTabNode abstractTabNode = (AbstractTabNode)this.tabs.get(i);
                d = Math.max(d, abstractTabNode.getTextHeight()) + this.getTabInsetFudgeFactor();
            }
            return d;
        }

        private double getTabInsetFudgeFactor() {
            if (System.getProperty("os.name").toLowerCase().indexOf("mac os x") >= 0) {
                return 2.0;
            }
            return 0.0;
        }

        private int getMaxTabHeight() {
            int n = 0;
            for (int i = 0; i < this.tabs.size(); ++i) {
                AbstractTabNode abstractTabNode = (AbstractTabNode)this.tabs.get(i);
                n = (int)Math.max((double)n, abstractTabNode.getFullBounds().getHeight());
            }
            return n;
        }

        public AbstractTabNode[] getTabs() {
            return this.tabs.toArray(new AbstractTabNode[0]);
        }

        public void setSelectedTab(AbstractTabNode abstractTabNode) {
            int n;
            this.selectedTab = abstractTabNode;
            for (n = 0; n < this.getTabs().length; ++n) {
                if (!this.getLayer().getChildrenReference().contains(this.getTabs()[n])) continue;
                this.getLayer().removeChild(this.getTabs()[n]);
            }
            for (n = this.getTabs().length - 1; n >= 0; --n) {
                if (this.getTabs()[n] == abstractTabNode) continue;
                this.getLayer().addChild(this.getTabs()[n]);
            }
            this.getLayer().removeChild(this.tabBase);
            this.getLayer().addChild(this.tabBase);
            this.getLayer().addChild(abstractTabNode);
        }

        public int getSelectedIndex() {
            return this.tabs.indexOf(this.selectedTab);
        }

        public int getTabCount() {
            return this.tabs.size();
        }

        protected AbstractTabNode getTab(int n) {
            return (AbstractTabNode)this.tabs.get(n);
        }

        public void setLogoVisible(boolean bl) {
            this.logoVisible = bl;
            this.updateLogoVisible();
        }

        public boolean getLogoVisible() {
            return this.logoVisible;
        }

        private void updateLogoVisible() {
            this.logo.setVisible(this.logoVisible && !this.logoObscured);
        }

        static /* synthetic */ void access$100(TabPane tabPane) {
            tabPane.relayout();
        }
    }

    public static class TabBase
    extends PNode {
        private final PPath path;
        private int tabBaseHeight = 6;
        private Color selectedTabColor;

        public TabBase(Color color) {
            this.selectedTabColor = color;
            this.path = new LowQualityPPath(new Rectangle(0, 0, 200, this.tabBaseHeight));
            this.path.setPaint(color);
            this.path.setPaint(new GradientPaint(0.0f, 0.0f, color, 0.0f, this.tabBaseHeight + 4, color.darker()));
            this.path.setStroke(null);
            this.addChild(this.path);
            this.updatePaint();
        }

        public void setTabBaseWidth(int n) {
            this.path.setPathTo(new Rectangle(0, 0, n, this.tabBaseHeight));
        }

        public void updatePaint() {
            this.path.setPaint(new GradientPaint(0.0f, 0.0f, this.selectedTabColor, 0.0f, this.tabBaseHeight, PhetTabbedPane.darker(this.selectedTabColor, 75)));
        }
    }

    public static abstract class AbstractTabNode
    extends PNode {
        private String text;
        private JComponent component;
        private PNode textNode;
        private LowQualityPPath background;
        private boolean selected;
        private float tiltWidth = 11.0f;
        private Color selectedTabColor;
        private PPath outlineNode;
        private Font tabFont;
        private boolean textIsCentered = true;
        private static final Insets tabInsets = new Insets(2, 15, 0, 15);

        public AbstractTabNode(String string, JComponent jComponent, Color color, Font font) {
            this.tabFont = font;
            this.selectedTabColor = color;
            this.text = string;
            this.component = jComponent;
            this.textNode = this.createTextNode(string, color);
            this.outlineNode = new PPath(this.createTabTopBorder(this.textNode.getFullBounds().getWidth(), this.textNode.getFullBounds().getHeight()));
            this.background = new LowQualityPPath(this.createTabShape(this.textNode.getFullBounds().getWidth(), this.textNode.getFullBounds().getHeight()));
            this.background.setPaint(color);
            this.background.setStroke(null);
            this.addChild(this.background);
            this.addChild(this.textNode);
            this.addChild(this.outlineNode);
        }

        protected abstract PNode createTextNode(String var1, Color var2);

        protected abstract void updateTextNode();

        public void setTabTextHeight(double d) {
            this.background.setPathTo(this.createTabShape(this.textNode.getFullBounds().getWidth(), d));
            this.outlineNode.setPathTo(this.createTabTopBorder(this.textNode.getFullBounds().getWidth(), d));
            if (this.textIsCentered) {
                this.textNode.setOffset(0.0, d / 2.0 - this.textNode.getHeight() / 2.0);
            }
        }

        private GeneralPath createTabTopBorder(double d, double d2) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(-AbstractTabNode.tabInsets.left, (float)(d2 + (double)AbstractTabNode.tabInsets.bottom));
            generalPath.lineTo(-AbstractTabNode.tabInsets.left, -AbstractTabNode.tabInsets.top);
            generalPath.lineTo((float)(d + (double)AbstractTabNode.tabInsets.right), -AbstractTabNode.tabInsets.top);
            generalPath.lineTo((float)d + (float)AbstractTabNode.tabInsets.right + this.tiltWidth, (float)(d2 + (double)AbstractTabNode.tabInsets.bottom));
            return generalPath;
        }

        private GeneralPath createTabShape(double d, double d2) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(-AbstractTabNode.tabInsets.left, -AbstractTabNode.tabInsets.top);
            generalPath.lineTo((float)(d + (double)AbstractTabNode.tabInsets.right), -AbstractTabNode.tabInsets.top);
            generalPath.lineTo((float)d + (float)AbstractTabNode.tabInsets.right + this.tiltWidth, (float)(d2 + (double)AbstractTabNode.tabInsets.bottom));
            generalPath.lineTo(-AbstractTabNode.tabInsets.left, (float)(d2 + (double)AbstractTabNode.tabInsets.bottom));
            generalPath.closePath();
            return generalPath;
        }

        public JComponent getComponent() {
            return this.component;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
            this.updateTextNode();
            this.background.setStroke(this.getBorderStroke());
            this.outlineNode.setVisible(bl);
            this.updatePaint();
        }

        private void updatePaint() {
            this.background.setPaint(this.getBackgroundPaint());
            this.background.setStrokePaint(this.getBorderStrokePaint());
        }

        private Paint getBorderStrokePaint() {
            return Color.gray;
        }

        private Stroke getBorderStroke() {
            return !this.selected ? new BasicStroke(1.0f) : null;
        }

        private Paint getBackgroundPaint() {
            if (this.selected) {
                return new GradientPaint(0.0f, (float)this.background.getFullBounds().getY() - 2.0f, this.selectedTabColor.brighter(), 0.0f, (float)(this.background.getFullBounds().getY() + 6.0), this.selectedTabColor);
            }
            return new GradientPaint(0.0f, 0.0f, new Color(240, 240, 240), 0.0f, 30.0f, new Color(200, 200, 200));
        }

        protected Paint getTextPaint() {
            return this.selected ? Color.black : Color.darkGray;
        }

        public Font getTabFont() {
            return this.tabFont;
        }

        public double getTextHeight() {
            return this.textNode.getFullBounds().getHeight();
        }
    }

    static class LowQualityPPath
    extends PPath {
        public LowQualityPPath(Shape shape) {
            super(shape);
        }

        protected void paint(PPaintContext pPaintContext) {
            Object object = pPaintContext.getGraphics().getRenderingHint(RenderingHints.KEY_RENDERING);
            pPaintContext.getGraphics().setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            super.paint(pPaintContext);
            if (object != null) {
                pPaintContext.getGraphics().setRenderingHint(RenderingHints.KEY_RENDERING, object);
            }
        }
    }

    public static class HTMLTabNode
    extends AbstractTabNode {
        private HTMLNode htmlNode;

        public HTMLTabNode(String string, JComponent jComponent, Color color, Font font) {
            super(string, jComponent, color, font);
        }

        protected PNode createTextNode(String string, Color color) {
            this.htmlNode = new HTMLNode(string, this.getTabFont(), Color.black);
            return this.htmlNode;
        }

        protected void updateTextNode() {
            this.htmlNode.setFont(this.getTabFont());
            this.htmlNode.setHTMLColor((Color)this.getTextPaint());
        }
    }

    public static class TabNodeFactory {
        public AbstractTabNode createTabNode(String string, JComponent jComponent, Color color, Font font) {
            return new HTMLTabNode(string, jComponent, color, font);
        }
    }
}

